<script id="flash-template" type="text/mustache">
	<?php echo mtk_render_twig(
        "@admin/widgets/flashmessage-single",
        array(
            "id" => "__NAME__",
            "locales" => osc_get_locales(),
            "current_local" => osc_current_admin_locale(),
            "custom_blocks" => __get("custom_blocks"),
            "pages" => __get("pages"),
            "static_pages" => __get("static_pages")
        )
    ); ?>
</script>
<script id="feature-template" type="text/mustache">
    <?php echo mtk_render_twig(
        "@admin/widgets/feature-single",
        array(
            "id" => "__NAME__",
            "locales" => osc_get_locales(),
            "current_local" => osc_current_admin_locale(),
            "custom_blocks" => __get("custom_blocks"),
            "pages" => __get("pages"),
            "static_pages" => __get("static_pages")
        )
    ); ?>
</script>
<?php foreach (__get("widgets") as $widget) : ?>
    <script id="<?php echo $widget["s_slug"]; ?>-template" type="text/mustache">
        <?php echo mtk_render_twig(
            "@admin/widgets/widget-single",
            array(
                "id" => '__NAME__',
                "widget_hook" => $widget,
                "locales" => osc_get_locales(),
                "current_local" => osc_current_admin_locale(),
                "custom_blocks" => __get("custom_blocks"),
                "pages" => __get("pages"),
                "static_pages" => __get("static_pages")
            )
        ); ?>
    </script>
<?php endforeach; ?>
<div class="space-in-lg bg-white b-b">
    <h2 class="h3 text-info row-space-2"><?php _e("Widgets", "themekitchen"); ?></h2>
    <p class="row-space-0"><?php _e("Widgets allow you to custom your theme. Just add a block, a static page or a custom html where you want in your webste. You also can sort them with drag and drop.", "themekitchen") ?></p>
</div>
<div class="bg-light lt space-in-lg b-b">
    <h3 class="h4 row-space-2">
        <?php _e("List of widget hooks", "themekitchen"); ?>
    </h3>
    <p class="text-muted">
        <?php _e("Widgets are the heart of the theme and what makes it magic. Add, remove and reorder widgets as you like to make your website as beautiful as you like.", "themekitchen"); ?>
    </p>
    <ol class="m-b-0">
        <li><a href="#section-flashmessages"><?php _e("flashmessages", "themekitchen") ?></a></li>
        <li><a href="#section-features"><?php _e("features", "themekitchen") ?></a></li>
        <?php foreach (__get("widgets") as $widget) : ?>
            <li>
                <a href="#section-<?php echo $widget["s_slug"]; ?>"><?php echo $widget["s_slug"]; ?></a>
            </li>
        <?php endforeach; ?>
    </ol>
</div>
<div class="">
    <div id="section-flashmessages" data-toggle="sheeper" data-min="0" data-prototype="#flash-template" data-container=".sheeps">
        <div class="space-in-lg b-b">
            <h3 class="h4 font-bold row-space-2"><?php _e("Flashmessages", "themekitchen"); ?></h3>
            <p class="text-muted">
                <?php _e("Flashmessages are banners displayed at the top of pages (below the navigation bar).", "themekitchen"); ?>
            </p>
            <p class="text-muted">
                <?php _e("Use them to give your users informations, about a discount, maintenance operations, encourage them to post an item or display a message for old browsers.", "themekitchen"); ?>
            </p>
            <a class="btn btn-link sheep-link row-space-3"><i class="ion-plus-circled">&nbsp;</i><?php _e("Add a new flashmessage", "themekitchen"); ?></a>
            <div class="sheeps panel-group">
                <?php foreach (mtk_field("$.widgets.flashmessages") as $index => $value) : ?>
                    <?php echo mtk_render_twig(
                        "@admin/widgets/flashmessage-single",
                        array(
                            "id" => $index,
                            "locales" => osc_get_locales(),
                            "current_local" => osc_current_admin_locale(),
                            "custom_blocks" => __get("custom_blocks"),
                            "pages" => __get("pages"),
                            "static_pages" => __get("static_pages")
                        )
                    ); ?>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
</div>
<div id="section-features" data-toggle="sheeper" data-min="0" data-prototype="#feature-template" data-container=".sheeps">
    <div class="bg-light b-b">
        <div class="space-in-lg">
            <h3 class="h4 font-bold row-space-2"><?php _e("Features", "themekitchen"); ?></h3>
            <p class="text-muted">
                <?php _e("Features explain to your visitors in a few bullet points what your website is about and how it works. Use them to guide the first steps of your visitors on your website.", "themekitchen"); ?>
            </p>
            <a class="btn btn-link sheep-link row-space-3"><i class="ion-plus-circled">&nbsp;</i><?php _e("Add a new feature", "themekitchen"); ?></a>
            <div class="sheeps panel-group">
                <?php foreach (mtk_field("$.widgets.features") as $index => $value) : ?>
                    <?php echo mtk_render_twig(
                        "@admin/widgets/feature-single",
                        array(
                            "id" => $index,
                            "locales" => osc_get_locales(),
                            "current_local" => osc_current_admin_locale(),
                            "custom_blocks" => __get("custom_blocks"),
                            "pages" => __get("pages"),
                            "static_pages" => __get("static_pages")
                        )
                    ); ?>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
</div>
<div class="">
    <?php foreach (__get("widgets") as $widget) : ?>
        <?php $w = $widget["s_slug"]; ?>
        <div id="section-<?php echo $w; ?>" class="bg-light b-b" data-toggle="sheeper" data-min="0" data-prototype="#<?php echo $w; ?>-template" data-container=".sheeps">
            <div class="space-in-lg">
                <h3 class="h4 font-bold row-space-2">
                    <?php _e("Hook:", "themekitchen"); ?>
                    <span class="text-info"><?php echo $w; ?></span>
                </h3>
                <a class="btn btn-link sheep-link row-space-3"><i class="ion-plus-circled">&nbsp;</i><?php _e("Add a new widget", "themekitchen"); ?></a>
                <?php if (true) : ?>
                    <div id="<?php echo $w ?>-widgets" class="sheeps panel-group">
                        <?php foreach (mtk_field("$.widgets." . $w) as $index => $value) : ?>
                            <?php echo mtk_render_twig(
                                "@admin/widgets/widget-single",
                                array(
                                    "id" => $index,
                                    "widget_hook" => $widget,
                                    "locales" => osc_get_locales(),
                                    "current_local" => osc_current_admin_locale(),
                                    "custom_blocks" => __get("custom_blocks"),
                                    "pages" => __get("pages"),
                                    "static_pages" => __get("static_pages")
                                )
                            ); ?>
                        <?php endforeach; ?>
                    </div>
                <?php else : ?>
                    <p class="text-center font-bold text-muted text-md"><?php printf(__("No widgets on '%s'.", "themekitchen"), $w); ?></p>
                <?php endif; ?>
            </div>
        </div>
    <?php endforeach; ?>
</div>