<?php

class Madhouse_ThemeKitchen_Modules_BackupModule extends Madhouse_ThemeKitchen_ModuleBase
{

    public function generateSQLScript($mode = "")
    {
        $model = new Madhouse_ThemeKitchen_Models_Settings();
        $moduleManager = Madhouse_ThemeKitchen_Services_ModuleManager::newInstance();
        $script = array();

        $tablename = $model->getTableName();
        if ($mode === "dev") {
            $tablename = preg_replace('/^(.*)(t_.*)$/', "/*TABLE_PREFIX*/$2", $tablename);
        }

        $delimiter = ';';
        if ($mode === "dev") {
            $delimiter = '|;|';
        }

        $script[] = "-- CREATE SETTINGS FIELDS FOR EACH MODULE";
        foreach ($moduleManager->getModules() as $module) {
            $script[] = sprintf(
                "%sINSERT IGNORE INTO %s (s_section, s_name, s_value) VALUE ('%s', '%s', '%s')%s",
                ($delimiter !== ';') ? "DELIMITER $delimiter " : "",
                $tablename,
                $model->getSection(),
                $model->getName($module),
                "",
                $delimiter
            );
        }

        $script[] = "-- SET SETTINGS FOR EACH MODULE";
        foreach ($moduleManager->getModules() as $module) {
            // Get and encode data.
            $data = json_encode(mtk_field("$." . $module->getId()));
            $data = str_replace('\r\n', '\\\\r\\\\n', $data); // Escape line feeds.
            $data = str_replace('\"', '\\\\"', $data); // Double escape quotes (within JSON).

            $script[] = sprintf(
                "%sUPDATE %s SET s_value = '%s' WHERE s_section = '%s' AND s_name = '%s'%s",
                ($delimiter !== ';') ? "DELIMITER $delimiter " : "",
                $tablename,
                $data,
                $model->getSection(),
                $model->getName($module),
                $delimiter
            );
        }

        $now = new DateTime();
        $script = array_merge(
            array("-- ThemeKitchen SQL Dump for theme='" . Madhouse_ThemeKitchen_Package::getThemeSlug() . "'\n-- " . $now->format(DateTime::ISO8601)),
            $script
        );

        return implode("\n\n", $script);
    }

    public function getViewFile()
    {
        return Madhouse_ThemeKitchen_Package::getPath("views/admin/_tab-backup.php");
    }

    public function getId()
    {
        return "backup";
    }
}
