<script type="text/javascript" src="<?php echo osc_plugin_url(""); ?>madhouse_messenger/assets/js/dist/web.js"></script>
<div class="container">
    <div class="m-y-lg">
        <?php if(mdh_thread()->isBlocked() && !mdh_thread()->isGroup()): ?>
            <div class="alert alert-danger">
                <?php printf(__("You blocked the user %s. He/She can't send you messages.", osc_current_web_theme()), mdh_thread()->getOther()->getName()); ?>
            </div>
        <?php endif; ?>
        <?php if(mdh_thread_has_status()): ?>
                <div class="alert alert-info p-md">
                    <p class="font-bold"><?php echo mdh_thread()->getStatus()->getTitle(); ?></p>
                    <p class="m-b-0"><?php echo mdh_thread()->getStatus()->getText(); ?></p>
                </div>
        <?php endif; ?>
        <div class="row thread-wrapper">
            <div class="col-md-8">
                <div class="row">
                    <div class="col-md-10 col-md-offset-1">
                        <div class="card">
                            <div class="card-block">
                                <h1 class="h3 m-b-md"><?php echo mdh_thread_title_default(__("Talking with",  osc_current_web_theme()) . " ") ?></h1>
                                <form class="form-vertical js-validate thread-message-form" action="<?php echo mdh_messenger_send_url(); ?>" method="POST" enctype="multipart/form-data">
                                    <input type="hidden" name="tid" value="<?php echo Params::getParam("id"); ?>" />
                                    <?php if (Params::existParam("secret")): ?>
                                        <input type="hidden" name="secret" value="<?php echo Params::getParam("secret"); ?>" />
                                    <?php endif; ?>
                                    <?php if (Params::existParam("email")): ?>
                                        <input type="hidden" name="email" value="<?php echo Params::getParam("email"); ?>" />
                                    <?php endif; ?>

                                    <div class="">
                                        <div class=" m-b-sm">
                                            <div class="">
                                                <textarea class="form-control" name="message" placeholder="<?php _e("Write something...", osc_current_web_theme()); ?>" rows="10"><?php echo osc_esc_html((Session::newInstance()->_getForm('pp_message') != '')?Session::newInstance()->_getForm('pp_message'):"")?></textarea>
                                            </div>
                                        </div>
                                        <?php if (mdh_messenger_resources_enabled()): ?>
                                            <div class="js-attachment-container" style="display:none">
                                                <div
                                                    class="control-group form-group js-attachment-wrapper clearfix"
                                                    data-attachment-max="<?php echo osc_get_preference('resources_max_per_message', mdh_messenger_preferences_section()); ?>"
                                                >
                                                    <div class="controls">
                                                        <div class="pull-right">
                                                            <button type="submit" class="btn btn-danger m-l-sm js-remove-button hidden btn-sm">
                                                                <?php _e("Remove", osc_current_web_theme())?>
                                                            </button>
                                                        </div>
                                                        <div class="input-group">
                                                          <span class="input-group-btn">
                                                            <label class="btn btn-default btn-sm" type="button">
                                                                <input class="js-attachment-file hidden" id="my-file-selector" name="attachment[]" type="file" onchange="$(this).parents('.input-group').find('.upload-file-info').val($(this).val().replace(/C:\\fakepath\\/i, ''));">
                                                                <?php _e("Choose a file", osc_current_web_theme()) ?>
                                                            </label>
                                                          </span>
                                                          <input type="text" class="input-sm upload-file-info form-control" placeholder="" readonly="">
                                                        </div><!-- /input-group -->
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endif; ?>

                                        <ul class="list-inline pull-left m-b-0">
                                            <?php if (mdh_messenger_resources_enabled()): ?>
                                                <li>
                                                    <a class="btn btn-primary btn-outline text-white js-add-attachment">
                                                        <?php _e("Add attachment", osc_current_web_theme()) ?>
                                                    </a>
                                                </li>
                                            <?php endif; ?>
                                        </ul>
                                        <div class="clearfix">
                                            <button class="btn btn-primary js-deactivate-on-submit pull-right width-full-xs" data-text-after-submit="<?php _e("Sending", osc_current_web_theme()) ?>" type="submit">
                                                <?php _e("Send message", osc_current_web_theme()); ?>
                                            </button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <ul class="thread-messages js-thread-messages list-unstyled row-space-0"
                    data-has-more="<?php echo(mdh_thread_has_more_messages()); ?>"
                    data-url="<?php echo mdh_messenger_ajax_url(); ?>"
                    data-content-read="<?php _e("Read", osc_current_web_theme()); ?>"
                    data-content-delete-action="<?php _e("Delete", osc_current_web_theme()); ?>"
                    data-number-per-page="<?php echo Params::getParam("n") ?>"
                    data-template-url="<?php echo osc_current_web_theme_url("plugins/madhouse_messenger/messages.twig"); ?>"
                    data-thread-id="<?php echo Params::getParam("id"); ?>"
                    data-autolinker-enable          = "<?php echo (osc_get_preference("enable_autolinker", "plugin_madhouse_messenger")); ?>"
                    data-autolinker-new-window      = "<?php echo (osc_get_preference("autolinker_new_window", "plugin_madhouse_messenger")); ?>"
                    data-autolinker-truncate-length = "<?php echo (osc_get_preference("autolinker_truncate_length", "plugin_madhouse_messenger")); ?>"
                    data-autolinker-strip-prefix    = "<?php echo (osc_get_preference("autolinker_strip_prefix", "plugin_madhouse_messenger")); ?>"
                >
                    <?php
                    echo mtk_render_twig("@web/plugins/madhouse_messenger/messages",
                        array(
                            "content" => [
                                "read" => __("Read", osc_current_web_theme()),
                                "deleteAction" => __("Delete", osc_current_web_theme())
                            ],
                            "messages" => array_map(
                                function($v) {
                                    return $v->toArray();
                                },
                                mdh_messages()
                            )
                        )
                    );
                    ?>
                </ul>
                <?php if(mdh_thread_has_more_messages()): ?>
                    <div class="js-thread-loader" style="display:none">
                        <?php mcf_spinner(false); ?>
                    </div>
                    <div class="text-center js-thread-no-more-message m-b-md" style="display:none">
                        <span><?php _e("No more message to load", osc_current_web_theme()) ?></span>
                    </div>
                <?php endif; ?>
            </div>
            <div class="sidebar col-md-4">
                <div class="card">
                    <div class="card-block">
                        <?php
                        while(mdh_thread_has_users()):
                            if (
                                (!osc_is_web_user_logged_in() && Params::getParam("email") != mdh_thread_user()->getEmail()) ||
                                (osc_is_web_user_logged_in() && mdh_thread_user_id() != osc_logged_user_id())
                            ): ?>
                                <div class="text-center">
                                    <?php if (osc_plugin_is_enabled("madhouse_avatar/index.php")): ?>
                                        <div class="m-b-md text-center">
                                            <a class="link-reset" href="<?php echo mdh_thread_user()->getURL() ?>">
                                                <img class="img-avatar" src="<?php echo mdh_avatar_preview_url(mdh_thread_user()->getId(), "_thumbnail"); ?>">
                                            </a>
                                        </div>
                                    <?php endif ?>
                                    <div class="thread-user-name font-bold text-md text-ellipsis">
                                        <?php if(mdh_thread_user()->isRegistered()): ?>
                                            <a class="link-reset" href="<?php echo mdh_thread_user()->getURL() ?>">
                                        <?php endif; ?>
                                            <?php if(mdh_thread()->isBlocked() && !mdh_thread()->isGroup()): ?>
                                                <i class="ion-minus-circled text-danger"></i>
                                            <?php endif; ?>
                                            <?php echo mdh_thread_user_name(); ?>
                                        <?php if(mdh_thread_user()->isRegistered()): ?>
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                    <ul class="list-unstyled text-sm">
                                        <?php if(!is_null(mdh_thread_user()->getBirthDate()) && mdh_thread_user()->isRegistered()): ?>
                                            <li class="thread-user-age">
                                                <span class="text-muted"><?php printf(__("%d years", osc_current_web_theme()),  date_diff(mdh_thread_user()->getBirthDate(), date_create('today'))->y); ?></span>
                                            </li>
                                        <?php endif; ?>
                                        <?php if (mdh_thread_user()->getNationality() != "" && mdh_thread_user()->isRegistered()): ?>
                                            <li class="thread-user-nationality">
                                                <span class="text-muted"><?php printf(__("From %s", osc_current_web_theme()), Madhouse_Utils_Countries::getName(mdh_thread_user()->getNationality())); ?></span>
                                            </li>
                                        <?php endif ?>
                                        <li class="text-muted">
                                            <?php if (mdh_thread_user()->isRegistered()): ?>
                                                <?php printf(__("Registered since %s", osc_current_web_theme()), strtolower(osc_format_date(mdh_thread_user()->getRegistrationDate(), "F o"))); ?>
                                            <?php else: ?>
                                                <?php _e("Unregistered user", osc_current_web_theme()) ?>
                                            <?php endif ?>
                                        </li>
                                        <?php if(mdh_thread_can_block()): ?>
                                            <li class="m-t-sm">
                                                <?php if(!mdh_thread()->isBlocked()): ?>
                                                    <a class="" href="<?php echo mdh_messenger_block_user_url(mdh_thread()->getId()); ?>">
                                                        <?php _e("Block user", osc_current_web_theme()); ?>
                                                    </a>
                                                <?php else: ?>
                                                    <a class="" href="<?php echo mdh_messenger_unblock_user_url(mdh_thread()->getId()); ?>">
                                                        <?php _e("Unblock user", osc_current_web_theme()); ?>
                                                    </a>
                                                <?php endif; ?>
                                            </li>
                                        <?php endif; ?>
                                        <?php if (osc_get_preference('subject_edit_enabled', mdh_current_preferences_section())): ?>
                                            <li class="m-t-sm">
                                                <a class=""
                                                    data-toggle="modal"
                                                    data-target="#js-thread-title"
                                                    href="#">
                                                    <?php _e("Edit subject", osc_current_web_theme())?>
                                                </a>
                                            </li>
                                            <div class="text-left modal fade" id="js-thread-title" tabindex="-1" role="dialog" aria-labelledby="thread-title">
                                                <div class="modal-dialog">
                                                    <div class="modal-content">
                                                        <div class="modal-header b-b-0">
                                                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                                                            <h3 class="modal-title"><?php _e("Edit subject",osc_current_web_theme()) ?></h3>
                                                        </div>
                                                        <div class="modal-body">
                                                            <form class="thread-title-form js-messenger-form" action="<?php echo mdh_messenger_title_url(); ?>" method="POST" enctype="multipart/form-data">
                                                                <?php if (Params::existParam("secret")): ?>
                                                                    <input type="hidden" name="secret" value="<?php echo Params::getParam("secret"); ?>" />
                                                                <?php endif; ?>
                                                                <?php if (Params::existParam("email")): ?>
                                                                    <input type="hidden" name="email" value="<?php echo Params::getParam("email"); ?>" />
                                                                <?php endif; ?>
                                                                <input type="hidden" name="tid" value="<?php echo Params::getParam("id"); ?>" />
                                                                <div class="">
                                                                    <div class="form-group control-group">
                                                                        <label class="control-label"><?php _e('Subject', 'madhouse_messenger'); ?></label>
                                                                        <input autocomplete="no" class="form-control control-form" type="text" name="subject" value="<?php echo osc_esc_html((Session::newInstance()->_getForm('pp_subject') != '')?Session::newInstance()->_getForm('pp_subject') : mdh_thread()->getTitle()) ?>" />
                                                                        <span class="help-block">
                                                                            <?php _e("Leave empty to remove the subject", osc_current_web_theme()); ?>
                                                                        </span>
                                                                    </div>
                                                                    <div class="form-group">
                                                                        <button class="btn btn-primary" type="submit">
                                                                            <?php _e("Update", osc_current_web_theme()); ?>
                                                                        </button>
                                                                    </div>
                                                                </div>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                        <?php if(mdh_messenger_status_enabled() && (! mdh_messenger_status_for_owner() || (mdh_messenger_status_for_owner() && mdh_is_thread_item_owner()))): ?>
                                            <li class="m-t-sm">
                                                <a class=""
                                                    data-toggle="modal"
                                                    data-target="#js-thread-status"
                                                    href="#">
                                                    <?php _e("Flag this thread", osc_current_web_theme())?>
                                                </a>
                                            </li>
                                            <div class="modal fade" id="js-thread-status" tabindex="-1" role="dialog" aria-labelledby="thread-status">
                                                <div class="modal-dialog">
                                                    <div class="modal-content">
                                                        <div class="modal-header b-b-0">
                                                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                                                            <h3 class="modal-title"><?php _e("Flag this thread",osc_current_web_theme()) ?></h3>
                                                        </div>
                                                        <div class="modal-body">
                                                            <p class="text-muted"><?php _e("It helps organize and you can see right away. You and the person you're talking to will see the flag.", osc_current_web_theme()) ?></p>
                                                            <?php while(mdh_has_status()):
                                                                if(
                                                                        !mdh_thread_has_status() ||
                                                                        (mdh_thread_has_status() && mdh_thread_status_id() !== mdh_status_id())
                                                                ): ?>
                                                                    <a class="btn btn-block m-b-sm btn-info" href="<?php echo mdh_status_url(); ?>"><?php _e("Flag to",osc_current_web_theme()) ?>&nbsp;"<?php echo mdh_status_title(); ?>"</a>
                                                                <?php endif;
                                                            endwhile; ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endif;  ?>
                                    </ul>
                                </div>
                            <?php
                            endif;
                        endwhile;
                        ?>
                    </div>
                </div>
                <?php if(mdh_thread_had_item() || (mdh_thread_has_item() && osc_item_is_expired()) ): ?>
                    <div class="alert alert-danger">
                        <div class="font-bold text-center">
                            <?php _e("Deleted/expired listing", osc_current_web_theme()); ?>
                        </div>
                    </div>
                <?php elseif(mdh_thread_has_item() && (osc_item_is_spam() || ! osc_item_is_enabled() || ! osc_item_is_active())): ?>
                    <div class="card card-danger">
                        <div class="card-header font-bold text-center">
                            <?php _e("Blocked/spam listing", osc_current_web_theme()); ?>
                        </div>
                    </div>
                <?php elseif(mdh_thread_has_item()): ?>
                    <?php
                    View::newInstance()->_exportVariableToView("search_show_as", "grid");
                    View::newInstance()->_exportVariableToView("col", "coucou");
                    osc_current_web_theme_path("parts/loop/loop-single.php");
                    ?>
                <?php else: ?>
                    <div class="card card-info">
                        <div class="card-header text-center hpadder">
                            <?php _e("No item linked to this thread.", osc_current_web_theme()); ?>
                        </div>
                    </div>
                <?php endif; ?>
                <?php if (mdh_thread_resources_count() > 0): ?>
                    <div class="card thread-resources">
                        <div class="card-block">
                            <h4><?php _e("All attachments", osc_current_web_theme()) ?></h4>
                            <ul class="list-unstyled thread-resources-list">
                                <?php while(mdh_thread_has_resources()): ?>
                                    <li class="text-ellispis">
                                        <a title="<?php echo osc_esc_html(mdh_thread_resource()->getOriginalName()); ?>" <?php echo  (mdh_thread_resource()->isImage())? 'class="fancybox text-ellipsis" rel="all"' : 'class="text-ellipsis" rel="all"'; ?> href="<?php echo mdh_thread_resource()->getUrl() ?>" target="_blank">
                                            <i class="<?php echo (mdh_thread_resource()->isImage()) ? 'ion-image' : 'ion-document' ?>"></i>
                                            <?php echo osc_esc_html(mdh_thread_resource()->getOriginalName()); ?>
                                        </a>
                                    </li>
                                <?php endwhile; ?>
                            </ul>
                        </div>
                    </div>
                <?php endif ?>
                <div class="card">
                    <div class="card-block">
                        <ul class="list-unstyled text-muted text-xs">
                            <li class=""><?php _e("Never pay with Western Union, Moneygram or other anonymous payment services", osc_current_web_theme()); ?></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php osc_current_web_theme_path('parts/footer.php') ; ?>
</body>
