<p>
    <?php _e("Don't have a username or want to change? You're in the right place.", osc_current_web_theme()); ?>
</p>
<form class="formValidate form-horizontal" action="<?php echo osc_base_url(true); ?>" method="post">
    <?php
    mcf_input_hidden("page", "user");
    mcf_input_hidden("action", "change_username_post");
    ?>
    <div class="form-group">
        <div class="controls">
            <label class="control-label col-sm-3"><?php _e("My username", osc_current_web_theme()); ?></label>
            <div class="col-sm-9">
                <input class="form-control" type="text" name="s_username" id="s_username" value="" placeholder="<?php _e("Enter your new username...", osc_current_web_theme());?>" />
                <span class="help-block" id="available">
            </div>
        </div>
    </div>
    <div class="form-group">
        <div class="controls col-sm-9 col-sm-offset-3">
            <button type="submit" class="btn btn-primary"><?php _e("Update", osc_current_web_theme());?></button>
        </div>
    </div>
</form>

<script type="text/javascript">
    $(document).ready(function() {
        var cInterval;
        $("#s_username").keydown(function(event) {
            if($("#s_username").val()!='') {
                clearInterval(cInterval);
                cInterval = setInterval(function(){
                    $.getJSON(
                        "<?php echo osc_base_url(true); ?>?page=ajax&action=check_username_availability",
                        {"s_username": $("#s_username").val()},
                        function(data){
                            clearInterval(cInterval);
                            if(data.exists==0) {
                                $("#available").text('<?php echo osc_esc_js(__("This username is available", osc_current_web_theme())); ?>');
                            } else if(data.s_username =="") {
                                $("#available").text('');
                            } else {
                                $("#available").text('<?php echo osc_esc_js(__("This username is NOT available", osc_current_web_theme())); ?>');
                            }
                        }
                    );
                }, 1000);
            }
        });

    });
</script>