<?php

$countryId = (osc_item_country_code()) ? osc_item_country_code() : (string) osc_user_field("fk_c_country_code");
$regionId  = (osc_item_region_id()) ? osc_item_region_id() : osc_user_region_id();
$region    = (osc_item_region()) ? osc_item_region() : osc_user_region();


$colLabel = __get('col_label');
$colInput = __get('col_input');

$countries = osc_get_countries();

if (__get("location_style")) {
    $regions = null;
    if (Session::newInstance()->_getForm('countryId') != "") {
        $regions = Region::newInstance()->findByCountry(Session::newInstance()->_getForm('countryId'));
    } elseif ($regions == null && $countryId != "") {
        $regions = Region::newInstance()->findByCountry($countryId);
    } elseif (count($countries) == 1) {
        $regions = Region::newInstance()->findByCountry($countries[0]['pk_c_code']);
    }

    $value = "";
    if (count($regions) >= 1) {
        $data = array("id" => "regionId");
        $value =array();
        $value['default']   = __("Select a region...", osc_current_web_theme());
        $value['choices']   = $regions;
        $value['current']   = $regionId;
        $value['key_value'] = 'pk_i_id';
        $value['key_name']  = 's_name';
        mcf_input_generic("select", 'regionId', $value, __("Region", osc_current_web_theme()), $colLabel, $colInput, $data);
    } else {
        $data = array("id" => "region");
        mcf_input_generic("text", 'region', $value, __("Region", osc_current_web_theme()), $colLabel, $colInput, $data);
    }
} else {
    mcf_input_generic("text", 'region', $region, __("Region", osc_current_web_theme()), $colLabel, $colInput, array('id' => 'region'));
    mcf_input_hidden("regionId", $regionId, array('id' => 'regionId'));
}