<?php

$country   = (osc_item_country()) ? osc_item_country() : osc_user_country();
$countryId = (osc_item_country_code()) ? osc_item_country_code() : (string) osc_user_field("fk_c_country_code");

$colLabel = __get('col_label');
$colInput = __get('col_input');

$data = array(
    "data-rule-minlength"=> 2,
    "data-msg-minlength"=>__("The country name is too short", osc_current_web_theme()),
    "data-rule-maxlength"=> 50,
    "data-msg-maxlength"=>__("The country name is too long (more than {0} characters)", osc_current_web_theme()),
    "id" => "country"
);

$countries = osc_get_countries();
if (count($countries) == 1):
        $country = $countries[0];
        mcf_input_hidden("countryId", $country['pk_c_code'], array('id' => 'countryId'));
    ?>
        <div class="form-group">
            <label class="<?php echo $colLabel ?> control-label"><?php _e("Country", osc_current_web_theme()) ?></label>
            <div class="<?php echo $colInput ?>">
                <span class="l-h-input"><?php echo $country['s_name'] ?></span>
            </div>
        </div>
    <?php
elseif (__get("location_style") && count($countries) >= 1) :
    $data['id'] = 'countryId';
    $value=array();
    $value['default']   = __("Select a country...", osc_current_web_theme());
    $value['choices']   = osc_get_countries();
    $value['current']   = $countryId;
    $value['key_value'] = 'pk_c_code';
    $value['key_name']  = 's_name';
    mcf_input_generic("select", 'countryId', $value, __("Country", osc_current_web_theme()), $colLabel, $colInput, $data);
elseif (__get("location_style") && count($countries) == 0) :
    mcf_input_generic("text", 'country', $country, __("Country", osc_current_web_theme()), $colLabel, $colInput, $data);
else:
    mcf_input_generic("text", 'country', $country, __("Country", osc_current_web_theme()), $colLabel, $colInput, $data);
    mcf_input_hidden("countryId", $countryId, array('id' => 'countryId'));
endif;