<div class="<?php echo (Params::getParam('quick-view') == "") ? "card" : "" ?>">
    <h2 class="<?php echo (Params::getParam('quick-view') == "") ? "card-header" : "title-special" ?> h4 item-description-title"><?php _e("Description", osc_current_web_theme()); ?></h2>
    <div class="<?php echo (Params::getParam('quick-view') == "") ? "card-block" : "" ?>">
        <div class="m-b-md">
            <p class="item-description m-b-0">
                <?php echo osc_item_description(); ?>
            </p>
        </div>
    </div>
</div>
<div class="<?php echo (Params::getParam('quick-view') == "") ? "card" : "" ?>">
    <h2 class="<?php echo (Params::getParam('quick-view') == "") ? "card-header" : "title-special" ?> h4 item-description-title"><?php _e("More information", osc_current_web_theme()); ?></h2>
    <div class="<?php echo (Params::getParam('quick-view') == "") ? "card-block" : "" ?>">
        <div class="custom-fields meta-fields m-b-md">
            <div class="global-metas row">
                <?php $metas = array(); ?>
                <?php if (Params::getParam('quick-view') != "") : ?>
                    <?php if (osc_price_enabled_at_items()) : ?>
                        <?php array_push($metas, array(
                                'label' => __("Price", osc_current_web_theme()),
                                'value' => osc_item_formated_price(),
                                'class' => 'text-primary'
                            )
                        ); ?>
                    <?php endif ?>

                    <?php array_push($metas, array(
                            'label' => __("Category", osc_current_web_theme()),
                            'value' => osc_item_category(),
                            'class' => 'text-primary'
                        )
                    ); ?>
                <?php endif ?>
                <?php
                array_push($metas, array(
                        'label' => __("Views", osc_current_web_theme()),
                        'value' => osc_item_views()
                    )
                );
                array_push($metas, array(
                        'label' => __("Listing id", osc_current_web_theme()),
                        'value' => osc_item_id()
                    )
                );

                array_push($metas, array(
                        'label' => __("Post date", osc_current_web_theme()),
                        'value' => mcf_format_date(osc_item_pub_date())
                    )
                );
                if (osc_item_mod_date() != "") {
                    array_push($metas, array(
                            'label' => __("Last edit", osc_current_web_theme()),
                            'value' => mcf_format_date(osc_item_mod_date())
                        )
                    );
                }

                foreach ($metas as $meta): ?>
                    <div class="col-md-6 p-y-sm <?php echo (isset($meta['class'])) ? $meta['class'] : '' ?>">
                        <div class="b-b clearfix">
                            <span class="font-bold pull-left"><?php echo $meta['label'] ?></span>
                            <span class="pull-right <?php echo (isset($meta['class'])) ? $meta['class'] : 'text-muted' ?>">
                                <?php echo $meta['value'] ?>
                            </span>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
            <div class="metas row">
                <?php if (osc_count_item_meta() >= 1) : ?>
                    <?php while (osc_has_item_meta()) : ?>
                        <?php if (osc_item_meta_value()!='') : ?>
                            <?php $meta = osc_item_meta(); ?>
                            <div class="col-md-6 p-y-sm">
                                <div class="b-b clearfix">
                                    <span class="font-bold pull-left"><?php echo osc_item_meta_name() ?></span>
                                    <span class="pull-right text-muted">
                                        <?php if ($meta['e_type']=="CHECKBOX") : ?>
                                            <?php if (osc_field(osc_item_meta(), 's_value', '')==1) : ?>
                                                <i class="ion-checkmark-round text-success"></i>
                                            <?php else : ?>
                                                <i class="ion-close-round text-danger"></i>
                                            <?php endif ?>
                                        <?php else : ?>
                                            <?php echo osc_item_meta_value() ?>
                                        <?php endif ?>
                                    </span>
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php endwhile; ?>
                <?php endif; ?>
            </div>
        </div>
        <div class="plugin-detail-hook">
            <?php osc_run_hook('item_detail', osc_item()); ?>
        </div>
    </div>
</div>