<?php
    /**
     * Head location:   base.php
     * Header location: parts/header.php
     * Footer location: parts/footer.php
     * The rest of the menu is generated with blocks set in the widget page in settings
     * Blocks location: parts/blocks/**
     */
?>
<header class="<?php echo (mtk_field("$.design", "i_content_boxed") == 1) ? "content-boxed" : "" ?>">
    <div class="navbar <?php echo (mtk_field("$.design", "i_navbar_inverse") == 1) ? "navbar-inverse" : "navbar-default"; ?>  <?php echo (mtk_field("$.design", "i_navbar_large") == 1) ? "navbar-lg" : ""; ?> navbar-flatshadow <?php echo (mtk_field("$.layout", "i_nav_fixed") == 1)?"navbar-fixed-top": "navbar-static-top" ?>" role="banner">
        <div class="container-fluid">
            <div class="navbar-header">
                <div class="navbar-brand-wrapper">
                    <a class="navbar-brand <?php echo (mtk_logo_url() != "")?"navbar-brand-img":"" ?>" href="<?php echo osc_base_url(); ?>">
                        <?php if (mtk_logo_url() != "") :
                        ?>
                            <img src="<?php echo mtk_logo_url() ?>">
                        <?php
                        else :
                            echo osc_page_title();
                        endif; ?>
                    </a>
                </div>
                <button class="js-slideout-toggle-button navbar-toggle m-r-0 m-l-md pull-left" type="button">

                    <span class="icon"></span>
                    <span class="sr-only">
                        <?php _e("Toggle navigation", osc_current_web_theme()); ?>
                    </span>
                </button>
            </div>
            <div class="main-menu collapse navbar-collapse main-menu" id="js-main-nav">
                <ul class="nav navbar-nav navbar-nav-alt">
                    <?php mtk_show_widgets("menu_left"); ?>
                </ul>
                <ul class="nav navbar-nav navbar-right navbar-nav-alt">
                    <?php mtk_show_widgets("menu_right"); ?>
                </ul>
            </div>
        </div>
    </div>
    <div class="header-widgets">
        <?php mtk_show_widgets("header"); ?>
        <?php
        if (mtk_is_user_page()) {
            osc_current_web_theme_path("parts/user/menu.php");
        }

            mcf_show_flash_message();
        ?>
    </div>
</header>
