<?php
/*
 * Block Name: Region form
 * Block Slug: search_region_form
 * Description: Blablabla.
 * Widget Hooks: search_sidebar
 */

if (mtk_field("layout", "i_search_location_style") == 0) :
    // Get the search country.
    $country = (osc_search_country() != "") ? Country::newInstance()->findByName(osc_search_country()) : "";

    // Get all regions within that country.
    $regions = RegionStats::newInstance()->listRegions(
        (!$country || $country == "") ? "%%%%" :  $country['pk_c_code'],
        mtk_field("layout", "i_search_location_select_display") ? ">" : ">="
    );



    // Map regions to add a label (since value is name).
    $regions = array_map(
        function ($region) {
            $region['label'] = $region["region_name"];
            return $region;
        },
        $regions
    );

    // Add default option.
    array_unshift(
        $regions,
        array(
            "label" => __("Choose a region", osc_current_web_theme()),
            "region_name" => "",
            "region_id" => ""
        )
    );

    // Display the select field.
    mcf_input_generic(
        "select",
        'sRegion',
        array(
            "choices" => $regions,
            "current" => Params::getParam('sRegion'),
            "key_name" => "label",
            "key_value" => (Params::existParam('sRegion') && !is_numeric(Params::getParam('sRegion'))) ? "region_name" : "region_id" ,
        ),
        __("Region", osc_current_web_theme()),
        "",
        "",
        array('id' => 'sRegion')
    );
else :
    $name = (is_numeric(Params::getParam('sRegion'))) ? "" : "sRegion";

    mcf_input_generic("text", $name, osc_esc_html(osc_search_region()), __("Region", osc_current_web_theme()), "", "", array('id' => 'sRegion'));
    if (is_numeric(Params::getParam('sRegion'))) {
        mcf_input_hidden("sRegion", Params::getParam('sRegion'));
    }
endif;
