<?php
/*
 * Block Name: City form
 * Block Slug: search_city_form
 * Description: Blablabla.
 * Widget Hooks: search_sidebar
 */

if (mtk_field("layout", "i_search_location_style") == 0) :
    // Get the search region if any.
    $region = (osc_search_region() != "") ? Region::newInstance()->findByName(osc_search_region()) : "";

    // Get all cities within this region.
    $cities = CityStats::newInstance()->listCities(
        (!$region || $region == "") ? null :  $region['pk_i_id'],
        mtk_field("layout", "i_search_location_select_display") ? ">" : ">="
    );
    // Map cities to add a label (since value is name).
    $cities = array_map(
        function ($city) {
            $city['label'] = $city["city_name"];
            return $city;
        },
        $cities
    );

    // Add default option.
    array_unshift(
        $cities,
        array(
            "label" => __("Choose a city", osc_current_web_theme()),
            "city_id" => "",
            "city_name" => "",
        )
    );

    // Display the input.
    mcf_input_generic(
        "select",
        'sCity',
        array(
            "choices" => $cities,
            "current" => Params::getParam('sCity'), // City name (not slug).
            "key_name" => "label",
            "key_value" => (Params::existParam('sCity') && !is_numeric(Params::getParam('sCity'))) ? "city_name" : "city_id" ,
        ),
        __("City", osc_current_web_theme()),
        "",
        "",
        array('id' => 'sCity')
    );
else :
    $name = (is_numeric(Params::getParam('sCity'))) ? "" : "sCity";
    mcf_input_generic("text", 'sCity', osc_esc_html(osc_search_city()), __("City", osc_current_web_theme()), "", "", array('id' => 'sCity'));
    if (is_numeric(Params::getParam('sCity'))) {
        mcf_input_hidden("sCity", Params::getParam('sCity'));
    }
endif;
