<?php
/*
 * Block Name: Menu User (dropdown)
 * Block Slug: menu_user_dropdown
 * Description: Blablabla.
 * Widget Hooks: menu_left, menu_right
 */ ?>

<?php
$menu = array();

if (mtk_field("$.layout", "i_dashboard_activation") == 0) {
    array_push(
        $menu,
        array(
            'label' => __("Dashboard", osc_current_web_theme()),
            'url' => osc_user_dashboard_url(),
            'class' => 'opt_dashboard',
            'active' => (osc_is_user_dashboard())? "active" :""
        )
    );
}

array_push(
    $menu,
    array(
    'label' => __("Account", osc_current_web_theme()),
    'url' => osc_user_profile_url(),
    'class' => 'opt_account',
    'active' => (osc_is_user_profile() || osc_is_change_email_page() || osc_is_change_password_page() || osc_is_current_page("user", "change_username"))? "active" :""
    ),
    array(
    'label' => __("Listings", osc_current_web_theme()),
    'url' => osc_user_list_items_url(),
    'class' => 'opt_items',
    'active' => (osc_is_list_items())? "active" :""
    ),
    array(
    'label' => __("Alerts", osc_current_web_theme()),
    'url' => osc_user_alerts_url(),
    'class' => 'opt_alerts',
    'active' => (osc_is_list_alerts())? "active" :""
    )
);
?>


<?php if (osc_users_enabled()) : ?>
    <?php if (osc_is_web_user_logged_in()) :?>
        <li id="logged-user" class="dropdown dropdown-hover"
            <?php
                /**
                 * Prints logged user informations as html5 data-* attributes (mainly for JS).
                 * Use the filter 'mcf_logged_user_data' to add some extra data-* attributes.
                 */
            foreach (osc_apply_filter("mcf_logged_user_data", array("id" => osc_logged_user_id(), "name" => osc_logged_user_name(), "url" => osc_user_public_profile_url(osc_logged_user_id()))) as $d => $v) :
                printf('data-%s="%s"', $d, $v);
            endforeach;
            ?>
        >
            <a class="navbar-avatar dropdown-toggle" href="<?php echo osc_user_dashboard_url(); ?>">
                <?php if (function_exists("mdh_avatar_nav_url")) :?>
                    <img class="hidden-sm img-avatar img-avatar-sm" src="<?php echo mdh_avatar_nav_url(osc_logged_user_id()) ;?>" />
                <?php endif; ?>
                <span class="username">
                    <?php echo strlen(osc_logged_user_name()) > 12 ? substr(osc_logged_user_name(), 0, 12)."..." : osc_logged_user_name(); ?>
                    <span class="caret hidden-xs hidden-sm"></span>
                </span>
            </a>
            <ul class="dropdown-menu hover-animated width-md" role="menu">
            <?php foreach ($menu as $key => $value) : ?>
                <li class="<?php echo $value["class"]; ?>">
                    <a href="<?php echo $value["url"]; ?>">
                        <?php echo $value["label"]; ?>
                    </a>
                </li>
            <?php endforeach; ?>
                <?php osc_run_hook("user_menu"); ?>
                <li class="divider"></li>
                <li>
                    <a href="<?php echo osc_user_public_profile_url(osc_logged_user_id()); ?>"
                    ><?php _e('Public Profile', osc_current_web_theme()); ?></a>
                </li>
                <li class="divider"></li>
                <li class="opt_logout">
                    <a href="<?php echo osc_user_logout_url(); ?>" >
                        <?php _e('Logout', osc_current_web_theme()); ?>
                    </a>
                </li>
            </ul>
        </li>
        <?php if (function_exists("mdh_messenger_widget")) : ?>
            <li>
                <?php mdh_messenger_widget(); ?>
            </li>
        <?php endif; ?>
    <?php else : ?>
        <?php if (!osc_is_login_form()) : ?>
            <?php if (mtk_field("layout", "i_login_mode") == 0) : ?>
            <li>
                <a href="<?php echo osc_user_login_url(); ?>"><?php _e("Login", osc_current_web_theme()); ?></a>
            </li>

        <?php elseif (mtk_field("layout", "i_login_mode") == 1) : ?>
            <li class="dropdown">
              <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-expanded="false"><?php _e("Login", osc_current_web_theme()); ?><span class="caret"></span></a>
              <div class="dropdown-menu hover-animated space-in width-xl" role="menu">
                <?php osc_current_web_theme_path('parts/user/login-form.php'); ?>
              </div>
            </li>
        <?php elseif (mtk_field("layout", "i_login_mode") == 2) : ?>
            <li>
                <a href="#" data-toggle="modal" data-target="#modalLogin">
                    <?php _e('Login', osc_current_web_theme()) ?>
                </a>
            </li>
            <li>
        <?php endif; ?>
      </li>
        <?php endif; ?>
        <?php if (osc_user_registration_enabled() && !osc_is_register_page()) : ?>
            <?php if (mtk_field("layout", 'i_register_mode') == 0) : ?>
                <li>
                    <a href="<?php echo osc_register_account_url(); ?>"><?php _e("Register", osc_current_web_theme()); ?></a>
                </li>
            <?php elseif (mtk_field("layout", 'i_register_mode') == 1) : ?>
                <li>
                    <a href="#" data-toggle="modal" data-target="#modalRegister">
                        <?php _e('Register', osc_current_web_theme()) ?>
                    </a>
                </li>
            <?php endif; ?>
        <?php endif; ?>
    <?php endif; ?>
<?php endif; ?>