<?php
/*
 * Block Name: Menu languages (dropdown)
 * Block Slug: menu_languages_dropdown
 * Description: Blablabla.
 * Widget Hooks: menu_left, menu_right
 */ ?>
<?php if (osc_count_web_enabled_locales() > 1) : ?>
    <li class="dropdown dropdown-hover">
        <a class="dropdown-toggle navbar-icon" role="button" data-toggle="dropdown">
            <i class="ion-ios-flag-outline hidden-xs"></i>
            <span class="visible-xs-inline">
                <?php _e('Languages', osc_current_web_theme()) ; ?><span class="caret"></span>
            </span>
        </a>
        <ul class="dropdown-menu hover-animated" role="menu">
            <?php osc_goto_first_locale() ; ?>
            <?php while (osc_has_web_enabled_locales()) : ?>
                <li class="<?php echo (osc_locale_code() == osc_current_user_locale()) ? "active" : "" ;?>">
                    <a
                        rel="nofollow"
                        href="<?php echo (osc_locale_code() != osc_current_user_locale()) ?
                                        osc_change_language_url(osc_locale_code()) : "#"; ?>"
                    >
                        <?php echo osc_locale_field('s_short_name') ; ?>
                    </a>
                </li>
            <?php endwhile; ?>
        </ul>
    </li>
<?php endif ?>