<?php
/*
 * Block Name: Dashboard items
 * Block Slug: dashboard_items
 * Description: Blablabla.
 * Widget Hooks: dashboard_content
 */ ?>


<div class="card">
    <h2 class="h5 card-header m-b-0">
        <?php _e("Listings", osc_current_web_theme()); ?>
    </h2>
    <?php if (osc_count_items() > 0) : ?>
        <div class="list-group">
            <?php while (osc_has_items()) : ?>
                <div class="list-group-item">
                    <div class="row">
                        <div class="col-sm-8">
                            <span class="text-ellipsis"><span class="label label-primary"><?php echo osc_item_category(); ?></span>&nbsp;<?php echo osc_item_title(); ?></span>
                        </div>
                        <div class="col-sm-4">
                            <a class="text-ellipsis text-right" href="<?php echo osc_item_edit_url(); ?>">
                                <?php _e("Edit item", osc_current_web_theme()); ?>
                            </a>
                        </div>
                    </div>
                </div>
            <?php endwhile; ?>
        </div>
        <div class="card-footer">
            <a class="btn btn-outline btn-primary" href="<?php echo osc_user_list_items_url(); ?>"><?php _e("See all listings", osc_current_web_theme()); ?></a>
        </div>
    <?php else : ?>
        <div class="row hbox height-lg text-center">
            <div class="col-middle col-sm-6 col-sm-offset-3 col-xs-11 col-xs-offset-2">
                <h2 class="h4"><?php _e("No listings have been added yet", osc_current_web_theme()); ?></h2>
                <a class="btn btn-primary btn-block" href="<?php echo(osc_item_post_url()); ?>"><?php _e("Post a listing", osc_current_web_theme()); ?></a>
            </div>
        </div>
    <?php endif; ?>

</div>