<?php

function mcf_enqueue_theme_variant() {
    // Get selected theme variant or default variant.
    $themeVariant = (mtk_field("$.design", "s_variant")) ? mtk_field("$.design", "s_variant") : "theme1";

    if (defined('DEMO') && DEMO == true) {
        // Loading requested variant for demo only.
        if (Params::getParam("theme_variant") !== "") {
            // Get variant in url.
            $themeVariant = Params::getParam("theme_variant");
            // Save variant to session.
            Session::newInstance()->_set("theme_variant", $themeVariant);
        } elseif (Session::newInstance()->_get("theme_variant") !== "") {
            $themeVariant = Session::newInstance()->_get("theme_variant");
        }

        osc_enqueue_style("web_main", osc_current_web_theme_url("assets/css/dist/$themeVariant.min.css"));
    } else {
        // Not in demo, ignore param/session.
        if (defined('OSC_DEBUG') && OSC_DEBUG) {
            // Working, writing code.
            $themeVariant = mtk_field("$.design", "s_variant");

            // Equeue the files.
            osc_enqueue_style("web_main", osc_current_web_theme_url("assets/css/dist/$themeVariant.min.css"));
            osc_enqueue_style("web_custom", osc_current_web_theme_url("assets/css/dist/overwrite.min.css"));
        } else {
            if (file_exists(WebThemes::newInstance()->getCurrentThemePath() . "/assets/css/dist/main.min.css")) {
                // main.min.css file exists, it includes current theme variant and overwrite from settings.
                $themeVariant = "main";
            }

            // Equeue the files.
            osc_enqueue_style("web_main", osc_current_web_theme_url("assets/css/dist/$themeVariant.min.css"));
        }

    }


}

/**
 * Simple title style
 * @return void
 */
function mcf_simple_title() {  ?>
    <div class="bg-gradient text-center text-white p-y-xl">
        <h1 class="h2"><?php echo mtk_title(); ?></h1>
    </div>
<?php
}

/**
 *
 * @since 1.00
 * Show flash message bootstrap
 */
function mcf_show_flash_message() {
    $messages = Session::newInstance()->_getMessage("pubMessages");
    if (is_array($messages)) {
        foreach ($messages as $message) {
            $message['type'] = ($message['type'] != 'ok')? $message['type'] : 'success' ;
            $message["type"] = ($message['type'] != 'error')? $message['type'] : 'danger' ;
            if (isset($message['msg']) && $message['msg'] != ''): ?>
                <div class="m-b-0 text-center alert alert-message alert-<?php echo $message['type']; ?> alert-full">
                    <button class="close" data-dismiss="alert" href="#">×</button>
                    <?php echo osc_apply_filter('flash_message_text', $message['msg']) ?>
                </div>
            <?php
            elseif($message!=''):
            ?>
                <div class="m-b-0 text-center alert alert-message alert-full alert-full alert-info">
                 <?php echo osc_apply_filter('flash_message_text', $message); ?>
                </div>
            <?php
            else:
            ?>
                <div class="alert-message alert" style="display:none;">
                    <?php echo osc_apply_filter('flash_message_text', ''); ?>
                </div>
            <?php
            endif;
        }
    }

    Session::newInstance()->_dropMessage("pubMessages");
}

/**
* Extend Pagination Class
*/
class ThemePagination extends Pagination
{
    public function __construct($params = null) {
        parent::__construct($params);
    }

    protected function createATag($text, $attrs)
    {
        $att = array();
        foreach($attrs as $k => $v) {
            $att[] = $k . '="' . $v . '"';
        }

        // Get page number
        $page = preg_replace("/^.*iPage(=|,)([0-9]+).*/i", "$2", $attrs["href"]);

        if ($page == $attrs["href"] ) {
            $page = preg_replace("/^.*\/([0-9]+)$/i", "$1", $attrs["href"]);
        }

        // For page 1
        if ($page == $attrs["href"] ) {
            $page = 1;

        }

        return '<li><a data-search-param="iPage" data-search-value="' . $page . '" ' . implode(' ', $att) . '>' . $text . '</a></li>';
    }

    public function doPagination()
    {
        if( $this->total > 1 ) {
            $links = $this->get_links();
            return '<nav><ul class="pagination m-t-0">' . implode($this->delimiter, $links) . '</ul></nav>';
        } else {
            return '';
        }
    }

    protected function createSpanTag($text, $attrs)
    {
        $att = array();
        foreach($attrs as $k => $v) {
            $att[] = $k . '="' . osc_esc_html($v) . '"';
        }

        $isCurrentPage = false;
        if ((osc_search_page() + 1) === $this->selected || (osc_item_comments_page() + 1) === $this->selected) {
            // This is some hacky stuff to highlight the current page is search and comments
            // despite Osclass Pagination.php limitations.
            $isCurrentPage = true;
        }

        return
            '<li class="' . ($isCurrentPage ? "active": "") . '">' .
                '<span ' . implode(' ', $att) . '>' . $text . '</span>'.
            '</li>';
    }
}

/**
 * Helper to use twitter pagination in user items
 */
function mcf_user_item_pagination($extraParams = array(), $itemsPerPage = false) {
    if(osc_is_public_profile()) {
        $url = osc_user_list_items_pub_profile_url('{PAGE}', $itemsPerPage);
        $firstUrl = osc_user_public_profile_url();
    } elseif(osc_is_list_items()) {
        $url = osc_user_list_items_url('{PAGE}', $itemsPerPage);
        $firstUrl = osc_user_list_items_url();
    }

    $params = array(
        'total'              => osc_search_total_pages(),
        'selected'           => osc_search_page(),
        'class_first'        => '',
        'class_last'         => '',
        'class_prev'         => 'prev',
        'class_next'         => 'next',
        'delimiter'          => '',
        'text_prev'          => sprintf(__('%s Previous', osc_current_web_theme()), '&laquo;'),
        'text_next'          => sprintf(__('Next %s', osc_current_web_theme()), '&raquo;'),
        'class_selected'     => 'active',
        'class_non_selected' => '',
        'force_limits'       => false,
        'first_url'          => $firstUrl,
        'url'                => $url
    );

    if(is_array($extraParams) && !empty($extraParams)) {
        foreach($extraParams as $key => $value) {
            $params[$key] = $value;
        }
    }
    $pagination = new ThemePagination($params);
    ?>
        <div class="pagination-wrapper">
            <?php echo $pagination->doPagination(); ?>
        </div>
    <?php
}

function mcf_pagination_default() {
    return array(
        'class_selected'     => 'js-search-filter active',
        'class_non_selected' => 'js-search-filter',
        'class_first'        => 'js-search-filter',
        'class_last'         => 'js-search-filter',
        'class_prev'         => 'js-search-filter prev',
        'class_next'         => 'js-search-filter next',
        'delimiter'          => '',
        'text_first'         => '&laquo;',
        'text_prev'          => sprintf(__('%s Previous', osc_current_web_theme()), '&larr;'),
        'text_last'          => '&raquo;',
        'text_next'          => sprintf(__('Next %s', osc_current_web_theme()), '&rarr;'),
    );
}

/**
 * Helper to use twitter pagination in search results
 */
function mcf_search_pagination() {
    $params              = mcf_pagination_default();
    $params['total']    = osc_search_total_pages();
    $params['selected'] = osc_search_page();

    if( View::newInstance()->_exists('search_uri') ) { // CANONICAL URL
        $params['url'] = osc_base_url().View::newInstance()->_get('search_uri') . '/{PAGE}';
        $params['first_url'] = osc_base_url().View::newInstance()->_get('search_uri');
    } else {
        $params['first_url'] = osc_update_search_url(array('iPage' => null));
    }

    $pagination = new ThemePagination($params) ;
    return $pagination->doPagination() ;
}

/**
 * Gets the pagination links of comments pagination
 *
 * @return string pagination links
 */
function mcf_comments_pagination() {
    if( (osc_comments_per_page() == 0) || (osc_item_comments_page() === 'all') || (osc_item_total_comments() <= osc_comments_per_page())) {
        return '';
    } else {
        $params = array_merge(
                    mcf_pagination_default(),
                    array(
                        'total'    => ceil(osc_item_total_comments()/osc_comments_per_page())
                        ,'selected' => osc_item_comments_page()
                        ,'url'      => osc_item_comments_url('{PAGE}')
                    )
                );
        $pagination = new ThemePagination($params);
        return $pagination->doPagination();
    }
}

function mcf_item_thumbnail($format = "grid") {
    if(osc_images_enabled_at_items()): ?>
        <?php if (osc_count_item_resources()): ?>
            <?php $resourceURL = osc_resource_preview_url(); ?>
        <?php else: ?>
            <?php $resourceURL = (mtk_no_photo_url("preview")) ?
                mtk_no_photo_url("preview") : osc_current_web_theme_url("assets/img/no-photo.jpg"); ?>
        <?php endif; ?>

        <?php if ((mtk_field("$.design", "i_masonry") && osc_search_show_as() !="list") || mtk_field("$.layout","i_search_slider") || !osc_is_search_page() || __get('listType') == 'premiums'): ?>
            <a
               class="loop-image-wrapper <?php echo ($format === "list") ? "card-img card-img-sm-left" : "" ?>"
               href="<?php echo osc_item_url(); ?>"
               title="<?php echo osc_esc_html(osc_item_title()); ?>"
            >
                <img
                    class="card-img"
                    src="<?php echo $resourceURL; ?>"
                    alt="<?php echo osc_esc_html(osc_item_title()) ; ?>"
                />
            </a>
        <?php else: ?>
            <div class="js-slider-search loop-image-wrapper">
                <?php if (osc_count_item_resources()): ?>
                    <?php while (osc_has_item_resources()): ?>
                        <div>
                            <a href="<?php echo osc_item_url() ; ?>">
                                <img class="card-img" data-lazy="<?php echo osc_resource_preview_url(); ?>">
                            </a>
                        </div>
                    <?php endwhile; ?>
                <?php else: ?>
                    <div>
                        <a href="<?php echo osc_item_url() ; ?>">
                            <img class="card-img" data-lazy="<?php echo $resourceURL; ?>">
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    <?php endif;
}

function mcf_item_location() {
    $location_array = array();
    if(trim(osc_item_city()." ".osc_item_zip())!='') {
        $location_array[] = trim(osc_item_city()." ".osc_item_zip());
    }
    if(osc_item_region()!='') {
        $location_array[] = osc_item_region();
    }
    if(osc_item_country()!='') {
        $location_array[] = osc_item_country();
    }
    $location = implode(", ", $location_array);
    unset($location_array);
    return $location;
}

/**
 * Return popular ads
 * @param  integer $limit   Maximum of ad return
 * @param  array   $filters Array of filters
 * @return integer          Number of result
 */
function mcf_popular_ads($limit = 10, $filters = array()) {

    $dao = Item::newInstance()->dao;

    $dao->select("i.*, l.*, SUM(s.i_num_views) AS total_views");
    $dao->from(Item::newInstance()->getTableName().' i');
    $dao->join(
                DB_TABLE_PREFIX.'t_item_location l',
                "l.fk_i_item_id = i.pk_i_id",
                "INNER"
    );
    $dao->join(
                DB_TABLE_PREFIX.'t_item_stats s',
                " s.fk_i_item_id = i.pk_i_id",
                "INNER"
    );
    $dao->where('l.fk_i_item_id = i.pk_i_id AND s.fk_i_item_id = i.pk_i_id');
    $dao->where('i.b_enabled = 1');
    $dao->where('i.b_active = 1');
    $dao->where('i.b_spam = 0');
    $dao->where('(i.b_premium = 1 || i.dt_expiration >= CURDATE())');
    $dao->groupBy('s.fk_i_item_id');
    $dao->orderBy('total_views', 'DESC');
    $dao->limit($limit);

    // Add category
    if (isset($filters['category']) && is_numeric($filters['category'])) {
        $categoryID = $filters['category'];
        if(Category::newInstance()->isRoot($categoryID)) { // You selected a category with subcategories
            $subCats = Category::newInstance()->toSubTree($categoryID);

            $cats = '';
            foreach($subCats as $cat) {
                $cats[] = $cat['pk_i_id'];
            }
            $catsToInclude = implode($cats, ",");
            $catsToInclude .= ",".$categoryID;
            $dao->where(sprintf('i.fk_i_category_id IN(%s)', $catsToInclude));
        } else {  // You selected a category with no children

            $dao->where(sprintf('i.fk_i_category_id IN(%s)', $categoryID));
        }
    }

    if (isset($filters['sRegion'])) {
        $region = trim($filters['sRegion']);
        if($region!="") {
            if(is_numeric($region)) {
                $dao->where(sprintf("l.fk_i_region_id = %d ", $dao->escapeStr($region)));
            } else {
                $dao->where(sprintf("l.s_region LIKE '%s' ", $dao->escapeStr($region)));
            }
        }
    }

    if (isset($filters['sCity'])) {
        $city = trim($filters['sCity']);
        if($city!="") {
            if(is_numeric($city)) {
                $dao->where(sprintf("l.fk_i_city_id = %d ", $dao->escapeStr($city)));
            } else {
                $dao->where(sprintf("l.s_city LIKE '%s' ", $dao->escapeStr($city)));
            }
        }
    }


    $result = $dao->get();
    if($result == false) {
        return 0;
    }
    $items  = $result->result();
    View::newInstance()->_exportVariableToView('customItems', Item::newInstance()->extendData($items));
    return count($items);
}


/**
 * Get related listings for one item and return them
 *
 * @return array listing
 */
function mcf_related_listings() {
    View::newInstance()->_exportVariableToView('customItems', array());

    $mSearch = new Search();
    $mSearch->addCategory(osc_item_category_id());
    $mSearch->addRegion(osc_item_region());
    $mSearch->addItemConditions(sprintf("%st_item.pk_i_id < %s ", DB_TABLE_PREFIX, osc_item_id()));
    $mSearch->limit('0', '9');

    $aItems      = $mSearch->doSearch();
    $iTotalItems = count($aItems);
    if( $iTotalItems == 3 ) {
        View::newInstance()->_exportVariableToView('customItems', $aItems);
        return $iTotalItems;
    }
    unset($mSearch);

    $mSearch = new Search();
    $mSearch->addCategory(osc_item_category_id());
    $mSearch->addItemConditions(sprintf("%st_item.pk_i_id != %s ", DB_TABLE_PREFIX, osc_item_id()));
    $mSearch->limit('0', '9');

    $aItems = $mSearch->doSearch();
    $iTotalItems = count($aItems);
    if( $iTotalItems > 0 ) {
        View::newInstance()->_exportVariableToView('customItems', $aItems);
        return $iTotalItems;
    }
    unset($mSearch);

    return 0;
}

function mcf_user_address() {
    $address = '';
    if(osc_user_address()!='') {
        if(osc_user_city_area()!='') {
            $address = osc_user_address().", ".osc_user_city_area();
        } else {
            $address = osc_user_address();
        }
    } else {
        $address = osc_user_city_area();
    }

    return $address;
}

function mcf_user_location() {

    $location_array = array();
    if(trim(osc_user_city()." ".osc_user_zip())!='') {
        $location_array[] = trim(osc_user_city()." ".osc_user_zip());
    }
    if(osc_user_region()!='') {
        $location_array[] = osc_user_region();
    }
    if(osc_user_country()!='') {
        $location_array[] = osc_user_country();
    }
    $location = implode(", ", $location_array);
    unset($location_array);
    return $location;
}

function mcf_item_label() {

    if (osc_item_is_spam()) {
        return __("Spam", osc_current_web_theme());
    } elseif (osc_item_is_expired()) {
        return __("Expired", osc_current_web_theme());
    } elseif (osc_item_is_active() && osc_item_is_enabled()) {
        return __("Active", osc_current_web_theme());
    } elseif (osc_item_is_inactive()) {
        return __("Inactive", osc_current_web_theme());
    }  elseif (!osc_item_is_enabled()) {
        return __("Blocked", osc_current_web_theme());
    }
}

function mcf_category_search($catId = null)
{
    $aCategories = array();
    if($catId==null) {
        $aCategories[] = Category::newInstance()->findRootCategoriesEnabled();
    } else {
        // if parent category, only show parent categories
        $aCategories = Category::newInstance()->toRootTree($catId);
        end($aCategories);
        $cat = current($aCategories);
        // if is parent of some category
        $childCategories = Category::newInstance()->findSubcategoriesEnabled($cat['pk_i_id']);
        if(count($childCategories) > 0) {
            $aCategories[] = $childCategories;
        }
    }

    if(count($aCategories) == 0) {
        return "";
    } ?>
    <ul class="list-unstyled m-b-0">
        <li>
            <a
                class="js-search-filter all-categories <?php echo (empty($catId))? "active" : ""  ?>"
                href="<?php echo osc_esc_html(osc_update_search_url(array('sCategory'=>null, 'iPage'=>null, 'sPriceMax' => ''))) ?>"
                data-search-param="sCategory"
                data-search-value=""
            >
                <?php _e('All categories', osc_current_web_theme()) ?>
            </a>
        </li>
        <?php mcf_print_category_search($aCategories, $catId); ?>
    </ul>
    <?php
}

function mcf_print_category_search($aCategories, $current_category = null, $depth = 0)
{

    if(!isset($aCategories[$depth])) {
        return null;
    }

    $c = $aCategories[$depth];
    $depth++;
    if(!isset($c['pk_i_id'])):
        foreach($c as $key => $value) :
            if (
                (
                    mtk_field("layout", "i_search_location_select_display") &&
                    $value['i_num_items'] > 0
                ) ||
                !mtk_field("layout", "i_search_location_select_display")
            ):
                mcf_print_category_link($value ,$current_category, $depth);
            endif;
        endforeach;
    else:
        mcf_print_category_link($c ,$current_category, $depth);
        mcf_print_category_search($aCategories, $current_category, $depth);
    endif;
}

function mcf_print_category_link($category, $currentCategory, $depth)
{
    $isActive  = isset($currentCategory) && $currentCategory == $category['pk_i_id'];
    $params = array('iPage'=>null, 'sPriceMax' => null);
    $params['sCategory'] = ($isActive) ? null : $category['s_slug'];
    ?>
    <li class="category-depth-<?php echo $depth ?>">
        <a  class="js-search-filter <?php echo ($isActive)? "active": ""; ?>"
            id="cat_<?php echo osc_esc_html($category['pk_i_id']);?>"
            href="<?php echo osc_esc_html(osc_update_search_url($params)); ?>"
            data-search-param="sCategory"
            data-search-value="<?php echo ($isActive)? "": $category['pk_i_id']; ?>"
        >
              <?php echo $category['s_name']; ?>
              <?php echo ($isActive) ? '<i class="ion-close-circled text-danger"></i>' : '' ?>
        </a>
    </li>
    <?php
}

function mcf_breadcrumb_text() {
    $lang = array();
    $lang['item_add']               = __('Publish a listing', osc_current_web_theme());
    $lang['item_edit']              = __('Edit your listing', osc_current_web_theme());
    $lang['item_send_friend']       = __('Send to a friend', osc_current_web_theme());
    $lang['item_contact']           = __('Contact publisher', osc_current_web_theme());
    $lang['search']                 = __('Search results', osc_current_web_theme());
    $lang['search_pattern']         = __('Search results: %s', osc_current_web_theme());
    $lang['user_dashboard']         = __('Dashboard', osc_current_web_theme());
    $lang['user_dashboard_profile'] = __("%s's profile", osc_current_web_theme());
    $lang['user_account']           = __('Account', osc_current_web_theme());
    $lang['user_items']             = __('Listings', osc_current_web_theme());
    $lang['user_alerts']            = __('Alerts', osc_current_web_theme());
    $lang['user_profile']           = __('Update account', osc_current_web_theme());
    $lang['user_change_email']      = __('Change email', osc_current_web_theme());
    $lang['user_change_username']   = __('Change username', osc_current_web_theme());
    $lang['user_change_password']   = __('Change password', osc_current_web_theme());
    $lang['login']                  = __('Login', osc_current_web_theme());
    $lang['login_recover']          = __('Recover password', osc_current_web_theme());
    $lang['login_forgot']           = __('Change password', osc_current_web_theme());
    $lang['register']               = __('Create a new account', osc_current_web_theme());
    $lang['contact']                = __('Contact', osc_current_web_theme());
    return $lang;
}

function mcf_spinner() { ?>
    <div class="spinner">
      <div class="double-bounce1"></div>
      <div class="double-bounce2"></div>
    </div>
<?php
}

function mcf_profile_filling_rate() {
    $total = 8;
    $missing = array();

    if (function_exists('mdh_avatar_has_user_resource')) {
        $total = 9;
        if (mdh_avatar_has_user_resource() == "") {
            array_push($missing, __('Add a profile picture',osc_current_web_theme()));
        }
    }

    if (is_numeric(osc_user_username())) {
        array_push($missing, __('Choose a username', osc_current_web_theme()));
    }

    if (osc_user_info() == "") {
        array_push($missing, __('Add a description for your profile', osc_current_web_theme()));
    }

    if (osc_user_phone() == "") {
        array_push($missing, __("Add your phone number", osc_current_web_theme()));
    }

    if (osc_user_country() == "") {
        array_push($missing, __("Add your country", osc_current_web_theme()));
    }

    if (osc_user_region() == "") {
        array_push($missing, __("Add your region", osc_current_web_theme()));
    }

    if (osc_user_city() == "") {
        array_push($missing, __("Add your city", osc_current_web_theme()));
    }

    if (osc_user_address() == "") {
        array_push($missing, __("Add your address", osc_current_web_theme()));
    }

    if (count($missing) == 0) {
        $rate = 100;
    } else {
        $rate = (100 * ($total - count($missing))) / $total;
    }

    return array(
        "rate" => $rate,
        "messages" => $missing
    );
}

function mcf_voting_can_vote() {
    return osc_plugin_is_enabled("voting/index.php") && osc_is_this_category('voting', osc_item_category_id()) && osc_get_preference('item_voting', 'voting') == '1' ;
}

function mcf_voting_result()
{
    if (mcf_voting_can_vote()) {
        $aux_vote  = ModelVoting::newInstance()->getItemAvgRating( osc_item_id() );
        $aux_count = ModelVoting::newInstance()->getItemNumberOfVotes( osc_item_id() );
        View::newInstance()->_exportVariableToView("voting_votes", $aux_vote['vote']);
        View::newInstance()->_exportVariableToView("voting_total", $aux_count['total']);

        osc_current_web_theme_path('plugins/voting/voting-results.php');
    }
}

function mcf_voting_user_result()
{
    if (!osc_plugin_is_enabled("voting/index.php")) {
        return;
    }

    $userId = null;

    if (osc_item_user_id()) {
        $userId = osc_item_user_id();
    } elseif (osc_user_id()) {
        $userId = osc_user_id();
    }

    if ( osc_get_preference('user_voting', 'voting') == 1 && !is_null($userId) && is_numeric($userId) && $userId > 0) {
        // obtener el avg de las votaciones
        $aux_vote  = ModelVoting::newInstance()->getUserAvgRating($userId);
        $aux_count = ModelVoting::newInstance()->getUserNumberOfVotes($userId);
        View::newInstance()->_exportVariableToView("voting_votes", $aux_vote['vote']);
        View::newInstance()->_exportVariableToView("voting_total", $aux_count['total']);

        osc_current_web_theme_path('plugins/voting/voting-results.php');
    }
}

/**
 * Return true if the item is already added in the watchlist
 * @return boolean true if in the watchlist
 * @since 1.1.1
 */
function mcf_is_in_watchlist()
{
    if (osc_item_id() != '' && osc_is_web_user_logged_in() && osc_plugin_is_enabled("watchlist/index.php")) {
        $id    = osc_item_id();
        //check if the item is not already in the watchlist
        $conn   = getConnection();
        $detail = $conn->osc_dbFetchResult("SELECT * FROM %st_item_watchlist WHERE fk_i_item_id = %d and fk_i_user_id = %d", DB_TABLE_PREFIX, osc_item_id(), osc_logged_user_id());

        //If nothing returned then we can process
        if (isset($detail['fk_i_item_id'])) {
            return true;
        } else {
            return false;
        }
    } else {
        return false;
    }
}

/**
 * Return the quick view url for an item.
 *
 * @return string
 *
 * @since 1.6.0 - works with both rewriten urls and not rewritten urls.
 *        1.5.0
 */
function mcf_quick_view_url() {
    $item = osc_item();
    $prefLocale = osc_current_user_locale();
    if (isset($item['locale'][$prefLocale]) && (!empty($item['locale'][$prefLocale]['s_title']))){
        $item['s_title'] = $item['locale'][$prefLocale]['s_title'];
    } else {
        $title = sprintf(__('%s in'), osc_item_category());
        if(isset($item['s_city'])) {
            $title .= ' ' . $item['s_city'];
        } else if(isset($item['s_region'])) {
            $title .= ' ' .$item['s_region'];
        } else if(isset($item['s_country'])) {
            $title .= ' ' . $item['s_country'];
        }
        $item['s_title'] = $title;
    }

    // Get the url from osclass.
    $itemUrl = osc_item_url_from_item($item);

    // Concat the quick-view param and return.
    return $itemUrl . ((osc_rewrite_enabled()) ? "?" : "&") . "quick-view=true";
}

/**
 * Helper to get alert locations
 * @param  array $values Sql of all locations search
 * @param  Dao $model  Location dao
 * @return Array of voting-results
 */
function mcf_alert_location($values, $model, $type) {
    $result = false;
    if (count($values) > 0) {

        $values = array_map(function ($v) use ($type) {
            if ($type == 'country') {
                if (strpos($v, 's_country')) {
                    return str_replace('oc_t_item_location.s_country', 's_name', $v);
                } else {
                    return str_replace('oc_t_item_location.fk_c_country_code', 'pk_c_code', $v);
                }
            } else {
                if (strpos($v, 's_' . $type)) {
                    return str_replace('oc_t_item_location.s_'. $type, 's_name', $v);
                } else {
                    return str_replace('oc_t_item_location.fk_i_'. $type . '_id', 'pk_i_id', $v);
                }
            }
        }, $values);

        $model->dao->select($model->getFields());
        $model->dao->from($model->getTableName());
        $model->dao->groupBy('s_name');
        foreach ($values as $sql) {
            $model->dao->orWhere($sql);
        }
        $result = $model->dao->get();

        if($result != false) {
            return array_map(function($v) {
                    return $v['s_name'];
                }, $result->result()
            );
        }
    }
    return $result;
}

/**
 * Return the searh subtitle with
 *     Category
 *     Region
 *     City
 *     User
 * @return string
 */
function mcf_search_subtitle() {
    $title = array();
    if (osc_search_total_items() == 1) {
        array_push($title , sprintf(__('%s listing', osc_current_web_theme()), osc_search_total_items()));
    } else {
        array_push($title , sprintf(__('%s listings', osc_current_web_theme()), osc_search_total_items()));
    }



    if (is_array(osc_search_category_id())) {

        View::newInstance()->_erase('categories');
        foreach (osc_search_category_id() as $id) {
            View::newInstance()->_exportVariableToView('category', osc_get_category('id', $id));
            array_push($title , strtolower(osc_category_name() ) );
        }
    }

    if (osc_search_country()) {
        array_push($title , ucwords(osc_search_country() ) );
    }

    if (osc_search_city()) {
        array_push($title , ucwords(osc_search_city() ) );
    }

    if (osc_search_region()) {
        array_push($title , ucwords(osc_search_region() ) );
    }


    if (osc_user_name() != "") {
        array_push($title , sprintf(__('of %s', osc_current_web_theme()), osc_user_name()));
    }

    return implode(' ', $title);
}

function mcf_format_date($date) {
    $today = new DateTime();

    $date = DateTime::createFromFormat('Y-m-d H:i:s', $date);

    $diff = $today->diff($date);
    $diffDays = (integer)$diff->format( "%R%a" );

    switch( $diffDays ) {
        case 0:
            $date = $date->format('H:i');
            $formatDate = sprintf(__("Today %s", osc_current_web_theme()), $date);
            break;
        case -1:
            $date = $date->format('H:i');
            $formatDate = sprintf(__("Yesterday %s", osc_current_web_theme()), $date);
            break;
        default:
            $formatDate = osc_format_date($date->format('Y-m-d H:i:s'), osc_date_format() . ' ' . osc_time_format());
            break;
    }
    return $formatDate;
}
