<?php

function mcf_input_value($name, $value) {

    $sessionValue = Session::newInstance()->_getForm($name);

    if($name != "" && !empty($sessionValue) && !is_array($sessionValue)) {
		if ($name == "price") {
			return osc_prepare_price($sessionValue); // Fix for price input
		}
        return osc_esc_html(htmlentities($sessionValue, ENT_COMPAT, "UTF-8"));
	}

	if(is_array($value)) {
		return "";
	}

	return osc_esc_html(htmlentities($value, ENT_COMPAT, "UTF-8"));
}

function mcf_data_attributes($data) {
	$result = "";
	foreach ($data as $key => $value) {
		$result .= ' ' . $key . '="' . osc_esc_html($value) . '"';
	}
	return $result;
}

function mcf_input_hidden($name, $value, $data = array()) { ?>
	<input type="hidden" name="<?php echo $name ?>" value="<?php echo mcf_input_value($name, $value); ?>" <?php echo mcf_data_attributes($data); ?>/>
<?php
}

function mcf_input_text($name, $value, $data = array()) { ?>
	<input class="form-control" type="text" name="<?php echo $name ?>" value="<?php echo mcf_input_value($name, $value); ?>" <?php echo mcf_data_attributes($data); ?>>
<?php
}

function mcf_input_password($name, $value, $data = array()) { ?>
	<input class="form-control" id="<?php echo preg_replace('|([^_a-zA-Z0-9-]+)|', '', $name) ?>" type="password" name="<?php echo $name ?>" value="<?php echo mcf_input_value($name, $value); ?>" <?php echo mcf_data_attributes($data); ?>>
<?php
}

function mcf_input_textarea($name, $value, $data) { ?>
	<textarea class="form-control " id="<?php echo $name ?>" name="<?php echo $name ?>" rows="7" <?php echo mcf_data_attributes($data); ?> ><?php echo mcf_input_value($name, $value); ?></textarea>
    <span id="<?php echo $name ?>counter"></span>
<?php
}

function mcf_input_select($name, $value) {
	?>
	<select class="form-control" name="<?php echo $name; ?>" id="<?php echo preg_replace('|([^_a-zA-Z0-9-]+)|', '', $name); ?>">
		<?php
		if (isset($value['default'])):
		?>
		<option value=""><?php echo $value['default'] ?></option>
		<?php
		endif;
		foreach($value["choices"] as $key => $v ):
		?>
			<option value="<?php echo $v[$value["key_value"]] ?>" <?php echo (mcf_input_value($name, $value["current"]) == $v[$value["key_value"]])? 'selected="selected"' : '';?> > <?php echo $v[$value["key_name"]]; ?></option>
		<?php
		endforeach;
		?>
	</select>
<?php
}

function mcf_input_radio($name, $values)
{
	?>
		<?php foreach($values["choices"] as $key => $v): ?>
			<label class="radio-inline">
				<input type="radio"
					   name="<?php echo $name ?>"
					   value="<?php echo $v[$values["key_value"]]; ?>"
					   <?php echo (mcf_input_value($name, $values["current"]) == $v[$values["key_value"]]) ? 'checked="checked"' : ''; ?>
				/> <?php echo $v[$values["key_name"]]; ?>
			</label>
		<?php endforeach; ?>
	<?php
}

function mcf_input_checkbox($name, $value)
{
	?>
		<div class="checkbox">
			<label>
				<input type="checkbox" name="<?php echo $name ?>" value="1" <?php echo (mcf_input_value($name, $value["value"]) == 1) ? 'checked="checked"' : ''; ?> /> <?php echo $value["label"] ?>
			</label>
		</div>
	<?php
}

function mcf_input_checkbox_multi($name, $values)
{
	?>
		<?php foreach ($values as $value): ?>
			<label class="checkbox-inline">
				<input type="checkbox" name="<?php echo $value["name"]; ?>" value="1" <?php echo (mcf_input_value($name, $value["value"]) == 1) ? 'checked="checked"' : ''; ?> /> <?php echo $value["label"] ?>
			</label>
		<?php endforeach; ?>
	<?php
}

function mcf_input_file($name, $value, $data = null)
{
	?>
		<div class="input-group">
			<span class="input-group-btn">
				<label class="btn btn-default" type="button">
					<input
						class="hidden"
						type="file"
						name="<?php echo $name; ?>"
						value="" <?php echo (!is_null($data)) ? mcf_data_attributes($data) : ""; ?>
						onchange="$(this).parents('.input-group').find('.upload-file-info').val($(this).val().replace(/C:\\fakepath\\/i, ''));"
					/>
				    <?php _e("Choose a file", osc_current_web_theme()) ?>
				</label>
			</span>
			<input type="text" class="upload-file-info form-control" placeholder="" readonly="">
		</div><!-- /input-group -->
	<?php
}

function mcf_button($text, $class = "btn-primary", $col = "col-sm-offset-3 col-sm-9") { ?>
	<div class="form-group">
		<div class="<?php echo $col ?>">
			<button class="btn <?php echo $class?>" type="submit"><?php echo $text; ?></button>
		</div>
	</div>
<?php
}

function mcf_input_generic($type, $name, $value, $label= "", $colLabel = "col-sm-3", $colInput = "col-sm-9", $data = array()) {
    ?>

	<div class="form-group">
		<?php if($colLabel != "" || ($colLabel  == "" && $label != "")): ?>
			<label class="<?php echo $colLabel ?> control-label" for="<?php echo $name ?>">
				<?php echo $label; ?>
			</label>
		<?php endif; ?>
		<div class="<?php echo $colInput ?>">
			<?php if($type == "text"):?>
				<?php mcf_input_text($name, $value, $data); ?>
			<?php elseif($type == "password"): ?>
				<?php mcf_input_password($name, $value, $data); ?>
			<?php elseif($type == "textarea"): ?>
				<?php mcf_input_textarea($name, $value, $data); ?>
			<?php elseif($type == "select"): ?>
				<?php mcf_input_select($name, $value); ?>
			<?php elseif($type == "radio"): ?>
				<?php mcf_input_radio($name, $value); ?>
			<?php elseif($type == "checkbox"): ?>
				<?php mcf_input_checkbox($name, $value); ?>
			<?php elseif($type == "checkbox_multi"): ?>
				<?php mcf_input_checkbox_multi($name, $value); ?>
			<?php elseif($type == "file"): ?>
				<?php mcf_input_file($name, $value, $data); ?>
			<?php endif;?>
		</div>
	</div>
<?php
}

function mcf_show_recaptcha($withWrapper = true) { ?>
    <?php if (osc_plugin_is_enabled("nocaptcha_recaptcha/index.php")): ?>
        <?php if ($withWrapper): ?>
            <div class="form-group">
        <?php endif; ?>

        <?php
            // Map route to nocaptcha_recaptcha settings name.
            $routeToSettings = array(
                "register_register" => "registration",
                "login" => "login",
                "item_item_add" => "new",
                "contact" => "contact",
                "item_contact" => "contact_listing",
                "item_send_friend" => "send_friend",
                "item" => "comment",
            );
            $route = implode("_", array_filter(array(Params::getParam("page"), Params::getParam("action"))));

            // Test if 'show on' is set at true for the current route.
            if (isset($routeToSettings["$route"]) && function_exists("anr_get_option") && anr_get_option($routeToSettings["$route"])) {
                // Run the hook from the plugin.
                osc_run_hook("anr_captcha_form_field");
            }
        ?>

        <?php if ($withWrapper): ?>
            </div>
        <?php endif; ?>
    <?php elseif (osc_recaptcha_public_key()): ?>

		<style type="text/css">
            .recaptchatable, #recaptcha_area tr, #recaptcha_area td, #recaptcha_area th{
                line-height: 0 !important;
             }
            #recaptcha_area input {
                height: auto;
                display: inline;
            }
        </style>
        <?php if($withWrapper): ?>
            <div class="form-group">
        <?php endif; ?>

		<?php
            // Show Osclass captcha.
            echo osc_show_recaptcha();
        ?>
        <div id="recaptcha"></div> <?php // Useful for register form in modal. ?>

		<?php if ($withWrapper): ?>
            </div>
        <?php endif; ?>
	<?php endif; ?>
    <?php
}

/*
 * Helpers used at view
 */

function mcf_category_select($categories = null, $item = null, $default_item = null, $parent_selectable = false)
{
	// Did user select a specific category to post in?
	$catId = Params::getParam('catId');
	if(Session::newInstance()->_getForm('catId') != "") {
		$catId = Session::newInstance()->_getForm('catId');
	}

	if($categories == null) {
		if(View::newInstance()->_exists('categories')) {
			$categories = View::newInstance()->_get('categories');
		} else {
			$categories = osc_get_categories();
		}
	}

	if ($item == null) { $item = osc_item(); }

	echo '<select class="form-control" name="catId" id="catId" required="required"
                    data-msg-required="'.__("This field is required", osc_current_web_theme()).'">';
	if(isset($default_item)) {
		echo '<option value="">' . $default_item . '</option>';
	} else {
		echo '<option value="">' . __('Select a category') . '</option>';
	}

	if(count($categories)==1) { $parent_selectable = 1; };

	foreach($categories as $c) {
		if ( !osc_selectable_parent_categories() && !$parent_selectable ) {
			echo '<optgroup label="' . $c['s_name'] . '">';
			if(isset($c['categories']) && is_array($c['categories'])) {
				ItemForm::subcategory_select($c['categories'], $item, $default_item, 1);
			}
		} else {
			$selected = ( (isset($item["fk_i_category_id"]) && $item["fk_i_category_id"] == $c['pk_i_id']) || (isset($catId) && $catId == $c['pk_i_id']) );
			echo '<option value="' . $c['pk_i_id'] . '"' . ($selected ? ' selected="selected"' : '' ). '>' . $c['s_name'] . '</option>';
			if(isset($c['categories']) && is_array($c['categories'])) {
				ItemForm::subcategory_select($c['categories'], $item, $default_item, 1);
			}
		}
	}
	echo '</select>';
	return true;
}

function mcf_category_multiple_selects($categories = null, $item = null, $default_item = null, $parent_selectable = false)
{

    $categoryID = Params::getParam('catId');
    if( osc_item_category_id() != null ) {
        $categoryID = osc_item_category_id();
    }

    if( Session::newInstance()->_getForm('catId') != '' ) {
        $categoryID = Session::newInstance()->_getForm('catId');
    }

    $tmp_categories_tree = Category::newInstance()->toRootTree($categoryID);
    $categories_tree = array();
    foreach($tmp_categories_tree as $t) {
        $categories_tree[] = $t['pk_i_id'];
    }
    unset($tmp_categories_tree);

    if($categories == null) {
        $categories = Category::newInstance()->listEnabled();
    }

    mcf_input_hidden("catId", $categoryID, array('id' => 'catId'));

    ?>
    <div id="select_holder"></div>
    <script type="text/javascript" charset="utf-8">
        <?php
            $tmp_cat = array();
            foreach($categories as $c) {
                if( $c['fk_i_parent_id']==null ) { $c['fk_i_parent_id'] = 0; };
                $tmp_cat[$c['fk_i_parent_id']][] = array($c['pk_i_id'], $c['s_name']);
            }
            foreach($tmp_cat as $k => $v) {
                echo 'var categories_'.$k.' = '.json_encode($v).';'.PHP_EOL;
            }
        ?>

        if(osc==undefined) { var osc = {}; }
        if(osc.langs==undefined) { osc.langs = {}; }
        if(osc.langs.select_category==undefined) { osc.langs.select_category = '<?php echo osc_esc_js(__('Select category')); ?>'; }
        if(osc.langs.select_subcategory==undefined) { osc.langs.select_subcategory = '<?php echo osc_esc_js(__('Select subcategory')); ?>'; }
        osc.item_post = {};
        osc.item_post.category_id    = '<?php echo $categoryID; ?>';
        osc.item_post.category_tree_id    = <?php echo json_encode($categories_tree); ?>;
        var selectableParentCategories = <?php echo (osc_selectable_parent_categories()) ? 'true' : 'false' ?>;
        $(document).ready(function(){
            <?php if($categoryID == array()): ?>
            draw_select(1,0);
            <?php else: ?>
                draw_select(1,0);
                <?php for($i=0; $i<count($categories_tree); $i++): ?>
                    draw_select(<?php echo ($i+2); ?> ,<?php echo $categories_tree[$i]; ?>);
                    <?php if (!osc_selectable_parent_categories()): ?>
                        $( '#select_<?php echo $i+2 ?>' ).rules( "add", {
                          required: true
                        });
                    <?php endif; ?>
                <?php endfor; ?>

            <?php endif; ?>

            $( '#select_1').rules( "add", {
              required: true
            });

            $('body').on("change", '[name^="select_"]', function() {
                var depth = parseInt($(this).attr("depth")),
                    value = $(this).val();
                for (var d=(depth+1);d<=4;d++) {
                    $("#select_"+d).trigger('removed');
                    $("#select_"+d).remove();
                }

                if (depth > 1 && value == 0) {
                    $("#catId").attr("value", $("#select_" + (depth - 1)).val());
                } else {
                    $("#catId").attr("value", value);
                }

                $("#catId").change();

                if((depth == 1 && value != 0) || (depth > 1 && value != $("#select_" + (depth - 1)).val())) {
                    draw_select(depth+1, value);
                }

                if (!selectableParentCategories) {
                    $( '#select_' + (depth + 1) + '-error').remove();
                    $( '#select_' + (depth + 1) ).rules( "add", {
                      required: true
                    });
                }

                $(this).valid();
                return true;
            });
        });

        function draw_select(select, categoryID) {
            tmp_categories = window['categories_' + categoryID];
            if( tmp_categories!=null && $.isArray(tmp_categories) ) {
                $("#select_holder").before('<select class="form-control m-b-sm" id="select_'+select+'" name="select_'+select+'" depth="'+select+'"></select>');

                if(categoryID==0) {
                    var options = '<option value="" >' + osc.langs.select_category + '</option>';
                }else {
                    var options = '<option value="" >' + osc.langs.select_subcategory + '</option>';
                }
                $.each(tmp_categories, function(index, value){
                    options += '<option value="' + value[0] + '" '+(value[0]==osc.item_post.category_tree_id[select-1]?'selected="selected"':'')+'>' + value[1] + '</option>';
                });
                osc.item_post.category_tree_id[select-1] = null;
                $('#select_'+select).html(options);
                $('#select_'+select).next("a").find(".select-box-label").text(osc.langs.select_subcategory);
                $('#select_'+select).trigger("created");
            };

        }
    </script>
<?php
}

function mcf_category_multiple_selects_search()
{
    ?>
    <div id="js-categories-selects"
        data-categories-tree='
                <?php
                $categories = Category::newInstance()->listEnabled();
                $cat = array();
                foreach (Category::newInstance()->listEnabled() as $category):
                    array_push(
                        $cat,
                        array(
                            "pk_i_id" => $category['pk_i_id'],
                            "s_name" => $category['s_name'],
                            "s_slug" => $category['s_slug'],
                            "fk_i_parent_id" => $category['fk_i_parent_id'],
                        )
                    );
                endforeach; ?>
            <?php echo json_encode($cat, JSON_HEX_APOS) ?>
        '
    ></div>
    <?php
    $categoryID = implode(',', osc_search_category_id());
    mcf_input_hidden("sCategory", $categoryID, array('id' => 'sCategory'));
}

function mcf_input_title($locale)
{
    $data = array(
        "data-rule-minlength"=> 2,
        "data-msg-minlength"=>__("The title is too short", osc_current_web_theme()),
        "data-rule-maxlength"=> osc_max_characters_per_title(),
        "data-msg-maxlength"=>__("The title is too long (more than {0} characters)", osc_current_web_theme()),
        "data-toggle" => "text-counter"
    );

    if (osc_current_user_locale() == $locale['pk_c_code']) {
    	$data["required"]="required";
    	$data["data-msg-required"]=__("This field is required", osc_current_web_theme());
    }

    $item = osc_item();
    $value = (isset($item) && isset($item['locale'][$locale['pk_c_code']]) && isset($item['locale'][$locale['pk_c_code']]['s_title'])) ? $item['locale'][$locale['pk_c_code']]['s_title'] : '';

    $sessionValue = Session::newInstance()->_getForm('title');

    if (is_array($sessionValue) && isset($sessionValue[$locale['pk_c_code']]) && !empty($sessionValue[$locale['pk_c_code']])) {
        $value = $sessionValue[$locale['pk_c_code']];
    }

    mcf_input_generic(
        "text",
        'title[' . $locale['pk_c_code'] . ']',
        $value,
        __("Title", osc_current_web_theme()),
        "col-sm-3",
        "col-sm-9",
        $data
    );
}

function mcf_input_description($locale)
{
    $data = array(
        "data-rule-minlength"=> 4,
        "data-msg-minlength"=>__("The description is too short", osc_current_web_theme()),
        "data-rule-maxlength"=> osc_max_characters_per_description(),
        "data-msg-maxlength"=>__("The description is too long (more than {0} characters)", osc_current_web_theme()),
        "data-toggle" => "text-counter"
    );

    if (osc_current_user_locale() == $locale['pk_c_code']) {
    	$data["required"]="required";
    	$data["data-msg-required"]=__("This field is required", osc_current_web_theme());
    }

    if (osc_plugin_is_enabled("richedit/index.php")) {
    	$data = array();
    }
    $item = osc_item();
    $value = (isset($item) && isset($item['locale'][$locale['pk_c_code']]) && isset($item['locale'][$locale['pk_c_code']]['s_description'])) ? $item['locale'][$locale['pk_c_code']]['s_description'] : '';

    $sessionValue = Session::newInstance()->_getForm('description');

    if (is_array($sessionValue) && isset($sessionValue[$locale['pk_c_code']]) && !empty($sessionValue[$locale['pk_c_code']])) {
        $value = $sessionValue[$locale['pk_c_code']];
    }

    mcf_input_generic(
        "textarea",
        'description[' . $locale['pk_c_code'] . ']',
        $value,
        __("Description", osc_current_web_theme()),
        "col-sm-3",
        "col-sm-9",
        $data
    );
}

function mcf_multilanguage_title_description($locales = null, $item = null) {
	if($locales==null) { $locales = osc_get_locales(); }
	if($item==null) { $item = osc_item(); }
	$num_locales = count($locales);

	if ($num_locales == 1) {
		foreach($locales as $locale) {
            mcf_input_title($locale);
            mcf_input_description($locale);
		}
	} else {
		?>
		<div role="tabpanel">
			<ul class="nav nav-tabs nav-underline" role="tablist">
			<?php
			foreach($locales as $locale):
			?>
				<li role="presentation" class="<?php echo (osc_current_user_locale() == $locale['pk_c_code'])?"active":""; ?>"><a href="#<?php echo $locale['pk_c_code'] ?>" aria-controls="<?php echo $locale['s_name'] ?>" role="tab" data-toggle="tab"><?php echo $locale['s_name'] ?></a></li>
			<?php
			endforeach;
			?>
			</ul>
			<div class="tab-content p-t-md">
				<?php
				foreach($locales as $locale) {
				?>
					<div role="tabpanel" class="tab-pane fade <?php echo (osc_current_user_locale() == $locale['pk_c_code'])?"in active":"";?>" id="<?php echo preg_replace('|([^_a-zA-Z0-9-]+)|', '', $locale['pk_c_code']) ?>">

						<div class="row m-b-md">
                            <div class="col-sm-9 col-sm-offset-3">
                                <span class="font-bold"><?php printf(__("Description in %s",osc_current_web_theme()), $locale['s_name']); ?></span>
                            </div>
                        </div>
						<?php mcf_input_title($locale); ?>
                        <?php mcf_input_description($locale); ?>
					</div>
					<?php
				}
				?>
			</div>
		</div>
		<?php
	}
}

/**
 *
 * @since 1.00
 * @override CategoryForm::category_select()
 */
function mcf_categories_select($default_item = null, $class="")
{
	// Params:
	$name = "sCategory";
	$categories = Category::newInstance()->toTree();
    $category = osc_search_category();
	if(is_null($default_item)) {
		$default_item = __("Select a category", osc_current_web_theme());
	}

    if (count($category) > 0) {
       $category = array(
       		'pk_i_id' => $category[0],
       		's_slug' => $category[0]
       	);
    } else {
        $category = array('pk_i_id' => "", "s_slug" => "");
    }

	// CategoryForm::category_select():
    echo '<select class="form-control i-select '.$class. '" name="' . $name . '" id="' . $name . '">';
    if(isset($default_item)) {
        echo '<option value="">' . $default_item . '</option>';
    }
    foreach($categories as $c) {
        echo '<option value="' . $c['pk_i_id'] . '"' . (($category['pk_i_id'] == $c['pk_i_id'] || $category['s_slug'] == $c['s_slug']) ? 'selected="selected"' : '' ) . '>' . $c['s_name'] . '</option>';
        if(count($category) >0 && isset($c['categories']) && is_array($c['categories'])) {
            mcf_subcategory_select($c['categories'], $category, $default_item, 1);
        }
    }
    echo '</select>';
}

function mcf_subcategory_select($categories, $category, $default_item = null, $deep = 0)
{
    $deep_string = "";
    for($var = 0;$var<$deep;$var++) {
        $deep_string .= '&nbsp;&nbsp;';
    }
    $deep++;
    foreach($categories as $c) {
        echo '<option value="' . $c['pk_i_id'] . '"' . ( ($category['pk_i_id'] == $c['pk_i_id']  || $category['s_slug'] == $c['s_slug']) ? 'selected="selected"' : '' ) . '>' . $deep_string.$c['s_name'] . '</option>';
        if(isset($c['categories']) && is_array($c['categories'])) {
            mcf_subcategory_select($c['categories'], $category, $default_item, $deep);
        }
    }
}

function mcf_category_checkbox_search() {
    osc_get_categories();
    if ( osc_count_categories() ) { ?>
        <?php // RESET CATEGORIES IF WE USED THEN IN THE HEADER ?>
        <?php osc_goto_first_category() ; ?>
        <div class="category-list">
            <?php while(osc_has_categories()): ?>

                <label class="label row-space-2 space-in-xs label-info" for="cat<?php echo osc_category_id(); ?>"><?php echo osc_category_name(); ?></label>

                <?php
                $parentSelected=false;
                if (in_array(osc_category_id(), osc_search_category()) ||
                    in_array(osc_category_slug()."/", osc_search_category()) ||
                    in_array(osc_category_slug(), osc_search_category()) ||
                    count(osc_search_category())==0 ) {
                        $parentSelected=true;
                }
                ?>
                <?php if(osc_count_subcategories() > 0) : ?>
                <ul class="list-unstyled">
                    <?php while(osc_has_subcategories()): ?>
                    <li>
                        <div class="checkbox">
                        <label for="cat<?php echo osc_category_id(); ?>">
                            <input type="checkbox"
                                id="cat<?php echo osc_category_id(); ?>"
                                name="sCategory[]"
                                value="<?php echo osc_category_id(); ?>"

                                <?php if( $parentSelected ||
                                    in_array(osc_category_id(), osc_search_category()) ||
                                    in_array(osc_category_slug()."/", osc_search_category()) ||
                                    in_array(osc_category_slug(), osc_search_category()) ||
                                    count(osc_search_category())==0 ){
                                        echo 'checked';
                                } ?>
                            />
                        <?php echo osc_category_name(); ?></label>
                    </li>
                    <?php endwhile; ?>
                </ul>
                <?php else: ?>
                <?php endif; ?>
            <?php endwhile; ?>
        </div>
    <?php }
}

?>
