<?php

/*
 * ==========================================================================
 *  LOADING
 * ==========================================================================
 */

require_once __DIR__ . "/vendor/composer_components/autoload.php";


/*
 * ==========================================================================
 *  INSTALL / UNINSTALL
 * ==========================================================================
 */

osc_add_hook("theme_activate", function ($theme) {
    Madhouse_Mcfly_Theme::install();
});

Madhouse_Mcfly_Theme::init();

/*
 * ==========================================================================
 *  ENQUE
 * ==========================================================================
 */

if (! OC_ADMIN) {

    /**
     * Register scripts.
     *
     */
    if (OSC_DEBUG) {
        osc_register_script(
            "web_theme_js",
            osc_current_web_theme_url("assets/js/dist/main.js"),
            "jquery"
        );
    } else {
        osc_register_script(
            "web_theme_js",
            osc_current_web_theme_url("assets/js/dist/main.min.js"),
            "jquery"
        );
    }

    osc_enqueue_style('fine-uploader-css', osc_assets_url('js/fineuploader/fineuploader.css'));
    osc_enqueue_script('jquery-fineuploader');

    osc_register_script(
        "jquery",
        osc_current_web_theme_url("vendor/bower_components/jquery/dist/jquery.min.js")
    );

    osc_register_script(
        "recaptcha",
        "https://www.google.com/recaptcha/api/js/recaptcha_ajax.js"
    );

    osc_add_filter(
        "body_class",
        function() {
            return (osc_is_custom_page()) ? Params::getParam('route') : "";
        }
    );

    osc_add_hook("header", function () {
        if (osc_plugin_is_enabled('google_maps/index.php')): ?>
            <script src="https://maps.google.com/maps/api/js?sensor=false&key=<?php echo osc_get_preference('maps_key', 'google_maps') ?>" type="text/javascript"></script>
        <?php endif;
    });

    /**
     * Enqueue styles.
     *
     */
    osc_enqueue_style("web_fonts", "https://fonts.googleapis.com/css?family=Montserrat:400,600,700|Asap:400,700,400italic,700italic");

    // Enqueue main css.
    mcf_enqueue_theme_variant();

    if (osc_recaptcha_public_key() != "") {
        osc_enqueue_script("recaptcha");
    }

    /**
     * Enqueue scripts.
     *
     */
    osc_enqueue_script("web_theme_js");
    //osc_enqueue_script('php-date'); // Required for datepicker custom fields.
    osc_remove_script("jquery-validate");
} else {

    /**
     * Add some custom settings to design tab of ThemeKitchen.
     */
    osc_add_hook("mdh_themekitchen_modules_design_show", function () {
        osc_current_web_theme_path("admin/parts/design.php");
    });
}
