<?php
    /**
     * This template is used as base structure of all pages
     */
?>
<!DOCTYPE html>
<html class="height-full">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="initial-scale=1.0,maximum-scale=1.0">
        <!-- Title -->
        <title><?php echo osc_esc_html(meta_title()); ?></title>

        <?php if (meta_description() !== "") : ?>
            <!-- Description -->
            <meta name="description" content="<?php echo osc_esc_html(meta_description()); ?>" />
        <?php endif; ?>

        <?php if (meta_keywords() !== "") :?>
            <!-- Keywords -->
            <meta name="keywords" content="<?php echo osc_esc_html(meta_keywords()); ?>" />
        <?php endif; ?>

        <?php if (osc_get_canonical() !== "") : ?>
            <!-- Canonical -->
            <link rel="canonical" href="<?php echo osc_get_canonical(); ?>"/>
        <?php endif; ?>

        <?php if (mtk_favicon_url() !== "") : ?>
            <!-- Favicon -->
            <link rel="icon" type="image/x-icon" href="<?php echo mtk_favicon_url(); ?>" />
        <?php endif; ?>

        <!-- Gettext ! -->
        <?php if (file_exists(osc_themes_path() . osc_theme() . '/languages/' . osc_current_user_locale() . '/theme.mo')) : ?>
        <link rel="gettext" type="application/x-po"
              href="<?php echo osc_current_web_theme_url("languages/" . osc_current_user_locale() . "/theme.po"); ?>" />
        <?php endif ?>

        <?php osc_run_hook("header"); ?>
    </head>
    <body class="height-full bg-light  main
        <?php if (mtk_field("$.layout", "i_nav_fixed") == 1 && mtk_field("$.design", "i_navbar_large") == 1) {
            echo "body-gap-lg";
        } elseif (mtk_field("$.layout", "i_nav_fixed") == 1) {
            echo "body-gap";
        } ?>
        <?php echo osc_apply_filter("body_class", ""); ?>
        "
        data-base-url="<?php echo osc_base_url() ?>"
        <?php echo osc_apply_filter("body_attr", ""); ?>
    >
        <div id="js-slideout-menu" class="navbar-inverse">

        </div>
        <?php osc_current_web_theme_path("parts/header.php"); ?>
        <main class="<?php echo (mtk_field("$.design", "i_content_boxed") == 1) ? "content-boxed" : "" ?>" id="js-slideout-panel">

            <?php osc_run_hook("main"); ?>
            <?php osc_current_web_theme_path("parts/footer.php"); ?>
        </main>
        <a href="#0" class="back-top bg-dark"><i class="ion-ios-arrow-up"></i></a>
        <?php if (mtk_field("layout", "i_login_mode") == 2) : ?>
            <?php osc_current_web_theme_path('parts/user/login-modal.php'); ?>
        <?php endif; ?>
        <?php if (mtk_field("layout", 'i_register_mode') == 1) : ?>
            <?php osc_current_web_theme_path('parts/user/register-modal.php'); ?>
        <?php endif; ?>
        <?php osc_current_web_theme_path('parts/item/quick-view-modal.php'); ?>
    </body>
</html>
