<?php
    /**
     * Head location:   base.php
     * Header location: parts/header.php
     * Footer location: parts/footer.php
     */
?>
<?php osc_add_hook("content", function () {
    ?>
    <div class="section section-astride text-center text-white">
        <h1 class="text-really-big p-lg pos-relative">404</h1>
    </div>
    <div class="section text-center">
        <div class="container">
            <p class="h2"><?php _e("Sorry, the page you're looking for doesn't exist", osc_current_web_theme()) ; ?></p>
            <p class="text-muted"><?php _e("Let us help you, we have got a few tips for you to find it.", osc_current_web_theme()) ; ?></p>
            <div class="row">
                <div class="col-sm-8 col-sm-offset-2">
                    <div class="card">
                        <div class="card-block">
                            <form class="" action="<?php echo osc_base_url(true) ; ?>" method="get" class="search">
                                <input type="hidden" name="page" value="search" />
                                <div class="input-group">
                                    <input
                                        class="form-control"
                                        type="text"
                                        name="sPattern"
                                        placeholder="<?php echo osc_esc_html(mtk_field("s_search_placeholder", osc_current_user_locale())); ?>"
                                        id="query" value="" />
                                    <span class="input-group-btn">
                                        <button type="submit" class="btn btn-primary">
                                            <?php _e('Search', osc_current_web_theme()) ; ?>
                                        </button>
                                    </span>
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-block m-b-0">
                            <div class="m-b-md">
                                <?php _e("<strong>Look</strong> for it in the most popular categories.", osc_current_web_theme()) ; ?>
                            </div>
                            <div class="categories row">
                                <?php osc_goto_first_category() ; ?>
                                <?php while (osc_has_categories()) : ?>
                                    <div class="col-sm-4 m-b-sm">
                                        <a class="category <?php echo osc_category_slug() ; ?>" href="<?php echo osc_search_category_url() ; ?>">
                                            <?php echo osc_category_name() ; ?>&nbsp;<span>(<?php echo osc_category_total_items() ; ?>)</span>
                                        </a>
                                    </div>
                                    <?php if (osc_count_subcategories() > 0) : ?>
                                        <?php while (osc_has_subcategories()) : ?>
                                            <?php if (osc_category_total_items() > 0) : ?>
                                                <div class="col-sm-4 m-b-sm">
                                                    <a class="category <?php echo osc_category_slug() ; ?>" href="<?php echo osc_search_category_url() ; ?>">
                                                        <?php echo osc_category_name() ; ?>&nbsp;<span>(<?php echo osc_category_total_items() ; ?>)</span>
                                                    </a>
                                                </div>
                                            <?php endif; ?>
                                        <?php endwhile; ?>
                                    <?php endif; ?>
                                <?php endwhile; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php }); ?>

<?php osc_current_web_theme_path("base-full.php"); ?>