<?php

function mtk_show_widgets($widgetHook, $wrapper = "")
{
    // Compute query on settings.
    $query = implode(".", array("$", "widgets", $widgetHook));

    // Get all widgets for $widgetHooks.
    $aWidgets = mtk_field($query);
    foreach ($aWidgets as $index => $widget) {
        // Compute new query for this widget.
        $subQuery = $query . "[" . $index . "]";

        if (mtk_widget_rule_location($subQuery) != false
            && mtk_widget_rule_category($subQuery) != false
            && mtk_field($subQuery, "b_enable")
        ) {
            // Wrap ?
            echo ($wrapper != "") ? '<div class="'.$wrapper.'">' : "";

            if (mtk_field($subQuery, "s_custom_widget")) {
                /*
                 * Block.
                 */
                mtk_render_block(mtk_field($subQuery, "s_custom_widget"));
            } elseif (mtk_field($subQuery, "s_static_page")) {
                /*
                 * Static page.
                 */

                osc_get_static_page(mtk_field($subQuery, "s_static_page"));

                echo "<h2>" . osc_static_page_title() . "</h2>";
                echo osc_static_page_text();
            } else {
                /**
                 * Custom code.
                 */
                echo mtk_field($subQuery, "s_text", osc_current_user_locale());
            }

            // Wrap ?
            echo ($wrapper != "") ? "</div>" : "";
        }
    }
}

function mtk_widget_rule_category($widget)
{
    // Get
    $sCategories = mtk_field($widget, "s_show_categories");
    if (strpos($sCategories, ',') !== false) {
        $aCategories =  explode(",", $sCategories);
    } elseif ($sCategories != "") {
        $aCategories = array($sCategories);
    } else {
        $aCategories = array();
    }

    //
    if (count($aCategories) != 0) {
        $currentCategories = array();

        if (osc_is_search_page()) {
            $currentCategories = osc_search_category_id();
        } elseif (osc_is_ad_page() || osc_is_item_contact_page()) {
            $currentCategories = array(osc_item_category_id());
        } else {
            return false;
        }

        if (count($aCategories) > 0 && array_intersect($aCategories, $currentCategories)) {
            return true;
        } else {
            return false;
        }
    } else {
        return true;
    }
}

function mtk_widget_rule_location($widget)
{
    $sLocations = mtk_field($widget, "s_show_locations");
    if (strpos($sLocations, ',') !== false) {
        $aLocations =  explode(",", $sLocations);
    } elseif ($sLocations != "") {
        $aLocations = array($sLocations);
    } else {
        $aLocations = array();
    }

    if (count($aLocations) != 0) {
        if (osc_is_search_page()) {
            $aCity = osc_search_city();
            $aRegion = osc_search_region();
            $aCountry = osc_search_country();
        } elseif (osc_is_ad_page() || osc_is_item_contact_page()) {
            $aCity = osc_item_city();
            $aRegion = osc_item_region();
            $aCountry = osc_item_country();
        } else {
            return false;
        }

        // Slugify locations part for comparison.
        $aLocations = array_map("strtolower", $aLocations);
        $aCity = strtolower($aCity);
        $aRegion = strtolower($aRegion);
        $aCountry = strtolower($aCountry);

        if (in_array($aCity, $aLocations) && !in_array($aRegion, $aLocations) && !in_array($aCountry, $aLocations) ||
            !in_array($aCity, $aLocations) &&  in_array($aRegion, $aLocations) && !in_array($aCountry, $aLocations) ||
            !in_array($aCity, $aLocations) && !in_array($aRegion, $aLocations) &&  in_array($aCountry, $aLocations)) {
            return true;
        } else {
            return false;
        }
    } else {
        return true;
    }
}


function mtk_widget_flash_messages()
{

    // if ($show_once) {
    //   if (!Session::newInstance()->_getForm('iePluginCheck')) {

    //     //echo 'session not set';
    //     Session::newInstance()->_setForm('iePluginCheck', true);
    //     // keep values on session
    //     Session::newInstance()->_keepForm('iePluginCheck');

    //   } else {

    //     $ie_check_show = false;
    //   }
    // }

    foreach (mtk_field("$.widgets.flashmessages") as $key => $value) {
        $flashMessage = "$.widgets.flashmessages[" . $key . "]";

        if (mtk_field($flashMessage, "b_enable")) {
            $bShowLocation = false;
            $bShowFilter = false;

            if (mtk_field($flashMessage, "b_show_everywhere")) {
                $bShowLocation = true;
            } elseif (mtk_field($flashMessage, "b_show_homepage") && osc_is_home_page()) {
                $bShowLocation = true;
            } elseif (mtk_field($flashMessage, "b_show_search") && osc_is_search_page()) {
                $bShowLocation = true;
            } elseif (mtk_field($flashMessage, "b_show_items") && (osc_is_ad_page() || osc_is_item_contact_page())) {
                $bShowLocation = true;
            } elseif (mtk_field($flashMessage, "b_show_users") && mtk_is_user_page()) {
                $bShowLocation = true;
            }

            if (mtk_widget_rule_location($flashMessage) != false && mtk_widget_rule_category($flashMessage) != false) {
                $bShowFilter = true;
            }

            $bShowBrowser = mtk_get_user_agent($flashMessage);

            if ($bShowLocation && $bShowFilter && $bShowBrowser) {
                $class = mtk_field($flashMessage, "s_custom_class");
                $class = ($class != "")? $class : "info";
                Session::newInstance()->_setMessage("pubMessages", mtk_field($flashMessage, "s_message", osc_current_user_locale()), $class);
            }
        }
    }
}

function mtk_get_user_agent($flashMessage)
{
    $iVersion = mtk_field($flashMessage, "b_show_on");

    if ($iVersion != "") {
        $aUserAgent = explode(' ', $_SERVER['HTTP_USER_AGENT']);
        $iMsieKey = array_search('MSIE', $aUserAgent);
        if ($iMsieKey !== false) {
            $iMsieVersion = intval($aUserAgent[$iMsieKey + 1]);
            if ($iMsieVersion < $iVersion) {
                return true;
            }
        }
        return false;
    } else {
        return true;
    }
}
