<?php

class Madhouse_ThemeKitchen_Services_ModuleManager
{
    /**
     * Static configuration object.
     *
     * @var Madhouse_ThemeKitchen_Settings2
     */
    protected $configuration;

    /**
     * Static configuration service.
     *
     * @var Themes
     */
    protected $themes;

    /**
     * Modules extending stuffs.
     *
     * @var Array<Madhouse_ThemeKitchen_Module>
     */
    protected $modules;

    /**
     * Dependency injection thing.
     *
     * @return $this
     */
    public static function newInstance()
    {
        // Dependencies to this object.
        $configurationService = Madhouse_ThemeKitchen_Services_StaticConfigurationService::newInstance();
        $configuration = $configurationService->findConfigurationBy();
        $themeManager = WebThemes::newInstance();

        // Create a new instance with inject dependencies.
        $that = new self($configuration, $themeManager);

        // Load all modules and return the new instance.
        $that
            ->addModule(new Madhouse_ThemeKitchen_Modules_GeneralModule())
            ->addModule(new Madhouse_ThemeKitchen_Modules_LayoutModule())
            ->addModule(new Madhouse_ThemeKitchen_Modules_DesignModule($configuration, $themeManager))
            ->addModule(new Madhouse_ThemeKitchen_Modules_SliderModule())
            ->addModule(new Madhouse_ThemeKitchen_Modules_CategoriesModule())
            ->addModule(new Madhouse_ThemeKitchen_Modules_WidgetsModule())
            ->addModule(new Madhouse_ThemeKitchen_Modules_SocialModule())
            ->addModule(new Madhouse_ThemeKitchen_Modules_BackupModule())
            ->addModule(new Madhouse_ThemeKitchen_Modules_Plugin())
        ;
        return $that;
    }

    /**
     * Constructor.
     *
     * @param Madhouse_ThemeKitchen_Settings2 $configuration
     * @param Themes                          $themeManager
     */
    public function __construct($configuration, $themeManager)
    {
        $this->configuration = $configuration;
        $this->themes = $themeManager;
    }

    /**
     * Add a module to this.
     *
     * @param $module
     */
    public function addModule($module)
    {
        $this->modules[] = $module;
        return $this;
    }

    /**
     * Return all the modules.
     *
     * @return Array<Madhouse_ThemeKitchen_Module>
     */
    public function getModules()
    {
        return $this->modules;
    }

    public function getModule($moduleId)
    {
        foreach ($this->getModules() as $module) {
            if ($module->getId() === $moduleId) {
                return $module;
            }
        }
        throw new Exception();
    }

    /**
     * Return all the assets.
     *
     * @return Array<string>
     */
    public function getAssets()
    {
        return array();
    }

    /**
     * Return all the subsets.
     *
     * @return Array<string>
     */
    public function getSubsets()
    {
        return array();
    }
}
