<?php

abstract class Madhouse_ThemeKitchen_ModuleBase
{
    /**
     * List of all subsets of this module.
     *
     * @var Array<string>
     */
    protected $subsets;

    public function __construct()
    {
    }

    /**
     * Return the unique identifier of this module.
     *
     * @return string
     */
    abstract public function getId();

    /**
     * Return the list of all assets.
     *
     * @return Array<string>
     */
    public function getAssets()
    {
        return array();
    }

    /**
     * Return the list of all subsets.
     *
     * @return Array<string>
     */
    public function getSubsets()
    {
        return array();
    }

    /**
     * Perform update operation.
     *
     * @param  Madhouse_ThemeKitchen_Settings $settings
     *
     * @return void
     */
    public function update($settings)
    {
        return;
    }

    /**
     * Perform operation needed to refresh.
     *
     * @param  Madhouse_ThemeKitchen_Settings $settings
     *
     * @return void
     */
    public function refresh($settings)
    {
        return;
    }
}
