<?php

class Madhouse_ThemeKitchen_Breadcrumb extends Breadcrumb
{

     public function __construct($lang = array())
    {
        parent::__construct($lang);
    }

    public function init()
    {
        parent::init();
        if( in_array($this->getLocation(), array('item', 'search')) ) {
            $this->setaLevel(array());
            $l = array(
                'url'   => osc_base_url(),
                'title' => osc_page_title()
            );
            $this->addLevel($l);
        }

        switch($this->getLocation()) {
            case('item'):


                switch ($this->getSection()) {
                    default:
                    case(''):
                        $location = $this->addLocations();
                        $this->addCategories(osc_item_category_id(), $location);
                        $l = array('title' => osc_item_title());
                        $this->addLevel($l);
                    break;
                }
            break;
            case('search'):
                    $region     = Params::getParam('sRegion');
                    $city       = Params::getParam('sCity');
                    $user       = Params::getParam('sUser');
                    $pattern    = osc_search_pattern();
                    $category   = osc_search_category_id();
                    $category   = ((count($category) == 1) ? $category[0] : '');

                    // show all

                    if( $pattern == '' && $category == '' && $region == '' && $city == '' && $user != '') {
                        $l = array('title' => __('Search results'));
                        $this->addLevel($l);
                        break;
                    }


                    $category = $this->addCategories($category);
                    $this->addLocations($category);
                    $this->addUsers();


                    // pattern
                    if( $pattern != '' ) {
                        $l = array('title' => sprintf(__('Search results: %s'), $pattern));
                        $this->addLevel($l);
                    }

                    // remove url from the last node
                    $nodes = $this->getaLevel();
                    if( $nodes > 0 ) {
                        if( array_key_exists('url', $nodes[count($nodes) - 1]) ) {
                            unset($nodes[count($nodes) - 1]['url']);
                        }
                    }
                    $this->setaLevel($nodes);
            break;
        }
    }

    private function addUsers()
    {
        $user       = Params::getParam('sUser');
        if (!empty($user)) {
            if(!is_numeric(Params::getParam('sUser'))) {
                $aUser = User::newInstance()->findByUsername($user);
            } else {
                $aUser = User::newInstance()->findByPrimaryKey($user);
            }
            if (count($aUser) == 0 && !is_numeric($user)) {
                $l = array(
                    'url'   => '',
                    'title' => $user
                );
                $this->addLevel($l);
            } else {
                $l = array(
                    'url'   => '',
                    'title' => $aUser['s_name']
                );
                $this->addLevel($l);
            }
        }
    }

    private function addLocations($category = null)
    {
        if ($this->getLocation() == 'item') {
            $country = osc_item_country();
            $region  = osc_item_region();
            $city    = osc_item_city();
        } else {
            $country = Params::getParam('sCountry');
            $region  = Params::getParam('sRegion');
            $city    = Params::getParam('sCity');
        }

        $params = array();
        if (!empty($category)) {
            $params['sCategory'] = $category;
        }

        if (!empty($city)) {
            if (is_numeric($city)) {
                $aCity = City::newInstance()->findByPrimaryKey($city);
            } else {
                $aCity = City::newInstance()->findByName($city);
            }
            if (count($aCity) == 0 && !is_numeric($city)) {
                $params['sCity'] = $city;
                $l = array(
                    'url'   => osc_search_url($params),
                    'title' => $city
                );
                $this->addLevel($l);
                return array('sCity' => $city);
            } else {
                $aRegion = Region::newInstance()->findByPrimaryKey($aCity['fk_i_region_id']);

                $params['sRegion'] = $aRegion['s_name'];
                $l = array(
                    'url'   => osc_search_url($params),
                    'title' => $aRegion['s_name']
                );
                $this->addLevel($l);

                $params['sRegion'] = '';
                $params['sCity'] = $aCity['s_name'];
                $l = array(
                    'url'   => osc_search_url($params),
                    'title' => $aCity['s_name']
                );

                $this->addLevel($l);
                return array('sCity' => $aCity['s_name']);
            }
        } elseif (!empty($region)) {
            if (is_numeric($region)) {
                $region = Region::newInstance()->findByPrimaryKey($region);
            } else {
                $region = Region::newInstance()->findByName($region);
            }
            if (!empty($region)) {

                $country = Country::newInstance()->findByCode($region['fk_c_country_code']);
                $params['sCountry'] = $country['pk_c_code'];
                $l = array(
                    'url'   => osc_search_url($params),
                    'title' => $country['s_name']
                );
                $this->addLevel($l);

                $params['sCountry'] = '';
                $params['sRegion'] = $region['pk_i_id'];
                $l = array(
                    'url'   => osc_search_url($params),
                    'title' => $region['s_name']
                );
                $this->addLevel($l);

                return array('sRegion' => $region['pk_i_id']);
            }
        } elseif (!empty($country)) {
            if (strlen($country) == 2) {
                $country = Country::newInstance()->findByCode($country);
            } else {
                $country = Country::newInstance()->findByName($country);
            }
            if (!empty($country)) {
                $params['sCountry'] = $country['pk_c_code'];
                $l = array(
                    'url'   => osc_search_url($params),
                    'title' => $country['s_name']
                );
                $this->addLevel($l);
                return array('sCountry' => $country['pk_c_code']);
            }
        }
    }

    private function addCategories($categoryId, $params = array())
    {
        if (!empty($categoryId)) {
            $aCategories = Category::newInstance()->toRootTree($categoryId);
            foreach( $aCategories as $c ) {
                View::newInstance()->_erase('categories');
                View::newInstance()->_erase('subcategories');
                View::newInstance()->_exportVariableToView('category', $c);

                $params['sCategory'] = osc_category_slug();
                $l = array(
                    'url'   => osc_search_url($params),
                    'title' => osc_category_name()
                );
                $this->addLevel($l);
            }
            return $c['s_slug'];
        }
    }
}
