<?php
    /**
     * Head location:   base.php
     * Header location: parts/header.php
     * Footer location: parts/footer.php
     */
?>
<?php
    osc_add_filter("mcf_oneaction_title", function ($text) {
        return mtk_title();
    });

    osc_add_filter("mcf_oneaction_smalltext", function ($text) {
        return __("This is something really cool to sign up on this website!", osc_current_web_theme());
    });
?>

<?php if (Params::existParam("modal_form")) : ?>
    <?php Session::newInstance()->_dropMessage('pubMessages'); ?>
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="modalRegister"><?php _e('Register', osc_current_web_theme()) ?></h4>
    </div>
    <div class="modal-body">
        <?php osc_current_web_theme_path('parts/user/register-form.php'); ?>
    </div>
    <div class="modal-footer">
        <a class="btn btn-primary btn-outline btn-block" href="<?php echo osc_user_login_url(); ?>"><?php _e("Login", osc_current_web_theme()); ?></a>
    </div>
    <script type="text/javascript">
        if (typeof Recaptcha != 'undefined') {
            // If Recaptcha is loaded (enabled).
            Recaptcha.create(
                "<?php echo osc_recaptcha_public_key() ?>",
                "recaptcha",
                {
                  theme: "red",
                  callback: Recaptcha.focus_response_field
                }
            );
        }

        $(".js-register-form").validate();
    </script>
<?php else : ?>

    <?php osc_add_hook("mcf_oneaction_body", function () {
    ?>
        <?php osc_current_web_theme_path('parts/user/register-form.php'); ?>

        <div class="text-center">
            <a class="" href="<?php echo osc_user_login_url(); ?>">
                <?php _e("Log in to your account", osc_current_web_theme()); ?>
            </a>
        </div>
    <?php }); ?>

    <?php osc_current_web_theme_path("base-oneaction.php"); ?>
<?php endif; ?>
