<?php
    /**
     * Head location:   base.php
     * Header location: parts/header.php
     * Footer location: parts/footer.php
     */
?>
<?php
    osc_add_filter("mcf_oneaction_title", function ($text) {
        return mtk_title();
    });

    osc_add_filter("mcf_oneaction_smalltext", function ($text) {
        return __("Oops! Give us your email and we'll send you an email to get your password back.", osc_current_web_theme());
    });
?>

<?php osc_add_hook("mcf_oneaction_body", function () {
    ?>
    <?php osc_run_hook('user_recover_form_before'); ?>
    <form class="form-vertical " action="<?php echo osc_base_url(true); ?>" method="post">
        <?php
        mcf_input_hidden("page", "login");
        mcf_input_hidden("action", "recover_post");
        mcf_input_generic("text", 's_email', "", __("Email", osc_current_web_theme()), '', '');
        osc_run_hook('user_recover_form');
        mcf_show_recaptcha();
        mcf_button(__('Send me a new password', osc_current_web_theme()), "btn-block btn-primary", "", "");
        ?>
    </form>
    <?php osc_run_hook('user_recover_form_after'); ?>
<?php }); ?>

<?php osc_current_web_theme_path("base-oneaction.php"); ?>
