<?php
    /**
     * Head location:   base.php
     * Header location: parts/header.php
     * Footer location: parts/footer.php
     */

    osc_add_filter("mcf_oneaction_title", function ($text) {
        return mtk_title();
        ;
    });

    osc_add_filter("mcf_oneaction_smalltext", function ($text) {
        return __("This is something really cool to sign up on this website!", osc_current_web_theme());
    });
?>

<?php osc_add_hook("mcf_oneaction_body", function () {
    ?>
    <?php osc_run_hook("mcf_register_before"); ?>
    <form action="<?php echo osc_base_url(true); ?>" method="post" >
        <?php
        mcf_input_hidden("page", "login");
        mcf_input_hidden("action", "forgot_post");
        mcf_input_hidden("userId", osc_esc_html(Params::getParam('userId')));
        mcf_input_hidden("code", osc_esc_html(Params::getParam('code')));
        mcf_input_generic("password", 'new_password', "", __("New password", osc_current_web_theme()), "", "");
        mcf_input_generic("password", 'new_password2', "", __("Repeat new password", osc_current_web_theme()), "", "");
        mcf_button(__('Change password', osc_current_web_theme()), "btn-block btn-primary");
        ?>
    </form>
<?php }); ?>

<?php osc_current_web_theme_path("base-oneaction.php"); ?>
