<form class="js-validate" action="<?php echo mdh_messenger_send_url(); ?>" method="post" name="contact_form">
    <?php if (osc_is_ad_page() || osc_is_item_contact_page()) : ?>
        <?php ContactForm::primary_input_hidden(); ?>
        <input type="hidden" name="recipients[]" value="<?php echo osc_item_user_id(); ?>" />
    <?php else : ?>
        <input type="hidden" name="recipients[]" value="<?php echo osc_user_id(); ?>" />
    <?php endif; ?>

    <div class="form-group">
        <div class="controls">
            <?php if (mdh_messenger_is_contacted()) : ?>
                <div class="wrapper-flash">
                    <div class="alert alert-info">
                        <p>
                            <?php printf(__("You already have contacted %s for this listing.", osc_current_web_theme()), osc_item_contact_name()) ?>
                        </p>
                        <a class="alert-link" href="<?php echo mdh_thread_url(); ?>"><?php _e('See thread', osc_current_web_theme()) ; ?></a>
                    </div>
                </div>
            <?php endif; ?>
            <label class="control-label">
                <?php _e("Message", osc_current_web_theme()); ?>
            </label>
            <textarea class="form-control" name="message" rows="10" placeholder="<?php _e("Write something...", osc_current_web_theme())?>"></textarea>
        </div>
    </div>
    <div class="form-group">
        <div class="controls">
            <button type="submit" class="btn btn-block btn-primary">
                <?php _e('Send message', osc_current_web_theme()) ; ?>
            </button>
        </div>
    </div>
</form>