<?php if(mtk_field("$.layout","i_search_title_position") == 0): ?>
    <div class="card">
        <div class="pos-relative">
            <?php if($searchCoverURL != ""): ?>
                <div class="background-cover overlay overlay-bottom-0 overlay-top-0 overlay-right-0 overlay-left-0 m-b-0 bg-dark">
                    <div class="bg-cover bg-cover-transparent"
                        style="background-image: url(<?php echo $searchCoverURL; ?>); height: 100%;">
                    </div>
                </div>
            <?php else: ?>
                <div class="bg-dark lter background-cover overlay overlay-bottom-0 overlay-top-0 overlay-right-0 overlay-left-0"
                >
                </div>
            <?php endif; ?>
            <div class="row hbox height-md"
            >
                <div class="col-xs-12 col-middle text-center">
                    <h1 class="h2 text-white"><?php echo (search_title()=="")?__("Search",osc_current_web_theme()):search_title(); ?></h1>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>
<?php if(mtk_field("$.layout", "i_search_category_refine") == 0 || mtk_field("$.layout", "i_search_category_refine") == 2) : ?>
    <?php osc_current_web_theme_path('parts/search/refine-category-wrapper.php'); ?>
<?php endif; ?>
<div class="row-space-3">
    <div class="navbar navbar-default">
        <div class="container-fluid">
            <ul class="nav navbar-nav navbar-left nav-underline">
                <li class="<?php echo (Params::getParam("type") == "")? "active": "" ?>">
                    <a class="js-search-filter" href="<?php echo osc_esc_html(osc_update_search_url(array('type'=> ''))); ?>" rel="nofollow" data-search-param="type" data-search-value="">
                        <?php _e('All',osc_current_web_theme()); ?></span>
                    </a>
                </li>
                <li class="<?php echo (Params::getParam("type") == "personal")? "active": "" ?>">
                    <a class="js-search-filter" href="<?php echo osc_esc_html(osc_update_search_url(array('type'=> 'personal'))); ?>" rel="nofollow" data-search-param="type" data-search-value="personal">
                        <span><?php _e('Personal',osc_current_web_theme()); ?></span>
                    </a>
                </li>
                <li class="<?php echo (Params::getParam("type") == "professional")? "active": "" ?>">
                    <a class="js-search-filter" href="<?php echo osc_esc_html(osc_update_search_url(array('type'=> 'professional'))); ?>" rel="nofollow" data-search-param="type" data-search-value="professional">
                        <span><?php _e('Professional',osc_current_web_theme()); ?></span>
                    </a>
                </li>
            </ul>
            <ul class="nav navbar-nav navbar-right nav-underline">
                <li class="hidden-xs <?php echo (Params::getParam("sShowAs") == "list")? "active": "" ?>">
                    <a  class="js-search-filter" href="<?php echo osc_esc_html(osc_update_search_url(array('sShowAs'=> 'list'))); ?>"
                        rel="nofollow"
                        data-search-param="sShowAs" data-search-value="list"
                    >
                        <i class="ion-navicon-round"></i>&nbsp;<span><?php _e('List',osc_current_web_theme()); ?></span>
                    </a>
                </li>
                <li class="hidden-xs <?php echo (Params::getParam("sShowAs") == "gallery")? "active": "" ?>">
                    <a class="js-search-filter" href="<?php echo osc_esc_html(osc_update_search_url(array('sShowAs'=> 'gallery'))); ?>"
                        rel="nofollow"
                        data-search-param="sShowAs" data-search-value="gallery"
                    >
                        <i class="ion-grid"></i>&nbsp;<span><?php _e('Grid',osc_current_web_theme()); ?></span>
                    </a>
                </li>
                <li class="dropdown dropdown-hover">
                    <a class="dropdown-toggle" data-toggle="dropdown" rel="nofollow" href="">
                        <i class="ion-funnel"></i>&nbsp;

                        <?php foreach(osc_list_orders() as $label => $params): ?>
                            <?php $iOrderType = (strtolower($params["iOrderType"]) === "asc") ? 0 : 1; ?>
                            <?php if(osc_search_order() == $params["sOrder"] && osc_search_order_type() == $iOrderType): ?>
                                <?php echo $label; ?>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </a>
                    <ul class="dropdown-menu hover-animated">
                        <?php foreach(osc_list_orders() as $label => $params): ?>
                            <?php $iOrderType = (strtolower($params["iOrderType"]) === "asc") ? 0 : 1; ?>
                            <?php if(osc_search_order() != $params["sOrder"] || osc_search_order_type() != $iOrderType): ?>
                                <li>
                                    <a
                                        href="<?php echo osc_esc_html(osc_update_search_url($params)); ?>"
                                        rel="nofollow"

                                    >
                                    <?php echo $label; ?>
                                    </a>
                                </li>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </ul>
                </li>
            </ul>
        </div>
    </div>
</div>
<?php if(osc_count_items() == 0): ?>
    <div class="p-xs-x-sm">
        <div class="alert alert-warning">
            <?php printf(__('There are no results matching "%s"', osc_current_web_theme()), osc_search_pattern()) ; ?>
        </div>
        <div class="card">
            <div class="card-block">
                <div class="m-b-md">
                    <?php _e("<strong>Look</strong> for it in the most popular categories.", osc_current_web_theme()) ; ?>
                </div>
                <?php osc_current_web_theme_path('parts/search/popular-categories.php'); ?>
            </div>
        </div>
    </div>
<?php else: ?>
    <?php
        osc_get_premiums((mtk_field("$.layout","i_search_item_premium_number") == "") ? 10 : mtk_field("$.layout","i_search_item_premium_number"));
        if(osc_count_premiums() > 0):
    ?>
        <?php
        if (mtk_field("layout", "i_search_item_premium_shuffle")) {
            $items = __get('premiums');
            shuffle($items);
            View::newInstance()->_exportVariableToView('premiums', $items);
        }
        View::newInstance()->_exportVariableToView(
        "loop_autoplay",
            mtk_field("layout", "i_search_item_premium_rotate")
        );
        View::newInstance()->_exportVariableToView("listType", 'premiums');
        View::newInstance()->_exportVariableToView("col", "m-x-sm");
        osc_current_web_theme_path('parts/loop/loop-carousel.php');
        ?>
    <?php endif; ?>

    <div class="p-xs-x-sm">
        <h2 class="h3 m-b">
            <?php echo mcf_search_subtitle(); ?>
        </h2>
    </div>
    <?php
    View::newInstance()->_exportVariableToView('search_show_as', Params::getParam("sShowAs"));
    View::newInstance()->_exportVariableToView('sShowAs', Params::getParam("sShowAs"));
    if (osc_search_show_as() !="list") {
        $class = 'col-xs-12 col-sm-6 col-md-4';
        $class .= (mtk_field("$.design", "i_masonry")) ? " grid-item" : "";
        View::newInstance()->_exportVariableToView("col", $class);
    } else {
        View::newInstance()->_exportVariableToView("col", "col-xs-12");
    } ?>
    <div class="row row-sm no-gutter-xs <?php echo (mtk_field("$.design", "i_masonry") && osc_search_show_as() !="list") ? "js-masonry" : ""?>">
        <?php osc_current_web_theme_path('parts/loop/loop.php'); ?>
    </div>

    <div class="p-xs-x-sm">
        <?php echo mcf_search_pagination(); ?>
    </div>
    <?php
    $categories = osc_search_category_id();
    if (count($categories) == 1) :
        View::newInstance()->_erase("categories");
        View::newInstance()->_exportVariableToView("category", osc_get_category('id', $categories[0]));
        if (osc_category_description() != "") :
        ?>
            <div class="card">
                <div class="card-block">
                    <?php echo osc_category_description() ?>
                </div>
            </div>
        <?php
        endif;
    endif;
    ?>
<?php endif; ?>
