<?php

$resources = array();
$resources = osc_get_item_resources(); //current resources
if (Session::newInstance()->_getForm('photos') != '') :
    $session = Session::newInstance()->_getForm('photos'); //session resources
    $resources = array_merge($resources, $session['name']);
    Session::newInstance()->_drop('photos');
    Session::newInstance()->_dropKeepForm('photos');
endif;

//allowed extensions
$aExt = explode(',', osc_allowed_extension());
foreach ($aExt as $key => $value) {
    $aExt[$key] = "image/".$value."";
}
$allowedExtensions = join(',', $aExt);

$dimThumbnail=explode("x", osc_get_preference("dimThumbnail"));

$edit = false;
if (Params::getParam('action') == 'item_edit') :
    $action = 'item_edit_post';
    $edit = true;
endif;

if (osc_images_enabled_at_items()) :
?>
<h2 class="title-special"><?php _e("Images", osc_current_web_theme()) ?></h2>
<div class="m-b-md">
    <div id="file-dropzone"
        class="dropzone panel b-a b-dashed b-2x"
        data-edit="<?php echo ($edit)?"true" :"false";?>"
        data-base-url="<?php echo osc_base_url() ?>"
        data-item-secret="<?php echo osc_item_secret() ?>"
        data-url="<?php echo osc_base_url(true)."?page=ajax&action=ajax_upload"; ?>"
        data-max-files-size="<?php echo (int) osc_max_size_kb() / 1024; ?>"
        data-accepted-files="<?php echo $allowedExtensions ?>"
        data-max-files="<?php echo (int) osc_max_images_per_item() ?>"
        data-resources='<?php echo json_encode($resources); ?>'

        data-thumbnail-width="<?php echo $dimThumbnail[0] ?>"
        data-thumbnail-height="<?php echo $dimThumbnail[1] ?>"

        data-dict-default-message="<?php _e("Or drop files here to upload", osc_current_web_theme()) ?>"
        data-dict-fallback-message="<?php _e("Your browser does not support drag'n'drop file uploads.", osc_current_web_theme()) ?>"
        data-dict-fallback-text="<?php _e("Please use the fallback form below to upload your files like in the older days.", osc_current_web_theme()) ?>"
        data-dict-file-too-big="<?php _e("File is too big ({{filesize}}MiB). Max filesize: {{maxFilesize}}MiB.", osc_current_web_theme()) ?>"
        data-dict-invalid-file-type="<?php _e("You can't upload files of this type.", osc_current_web_theme()) ?>"
        data-dict-response-error="<?php _e("Server responded with {{statusCode}} code.", osc_current_web_theme()) ?>"
        data-dict-cancel-upload="<?php _e("Cancel upload", osc_current_web_theme()) ?>"
        data-dict-cancel-upload-confirmation="<?php _e("Are you sure you want to cancel this upload?", osc_current_web_theme()) ?>"
        data-dict-remove-file="<?php _e("Remove file", osc_current_web_theme()) ?>"
        data-dict-remove-file-confirmation="<?php _e("Are you sure you want to remove this file?", osc_current_web_theme()) ?>"
        data-dict-max-files-exceeded="<?php _e("You can not upload any more files.", osc_current_web_theme()) ?>"
        >
        <li class="dz-preview dz-file-preview hpadder-sm " id="template">
            <div class="dz-image b-a b-2x" style="height:<?php echo $dimThumbnail[1] ?>px; width:<?php echo $dimThumbnail[0] ?>px"><img class="img-responsive" data-dz-thumbnail /></div>
            <div class="dz-details">
                <div class="dz-size"><span data-dz-size></span></div>
                <div class="dz-filename"><span data-dz-name></span></div>
            </div>
            <div class="dz-progress"><span class="dz-upload" data-dz-uploadprogress></span></div>
            <div class="dz-error-message"><span data-dz-errormessage></span></div>
            <div class="dz-success-mark">
                <svg width="54px" height="54px" viewBox="0 0 54 54" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:sketch="http://www.bohemiancoding.com/sketch/ns">
                <title>Check</title>
                <defs></defs>
                <g id="Page-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd" sketch:type="MSPage">
                  <path d="M23.5,31.8431458 L17.5852419,25.9283877 C16.0248253,24.3679711 13.4910294,24.366835 11.9289322,25.9289322 C10.3700136,27.4878508 10.3665912,30.0234455 11.9283877,31.5852419 L20.4147581,40.0716123 C20.5133999,40.1702541 20.6159315,40.2626649 20.7218615,40.3488435 C22.2835669,41.8725651 24.794234,41.8626202 26.3461564,40.3106978 L43.3106978,23.3461564 C44.8771021,21.7797521 44.8758057,19.2483887 43.3137085,17.6862915 C41.7547899,16.1273729 39.2176035,16.1255422 37.6538436,17.6893022 L23.5,31.8431458 Z M27,53 C41.3594035,53 53,41.3594035 53,27 C53,12.6405965 41.3594035,1 27,1 C12.6405965,1 1,12.6405965 1,27 C1,41.3594035 12.6405965,53 27,53 Z" id="Oval-2" stroke-opacity="0.198794158" stroke="#747474" fill-opacity="0.816519475" fill="#FFFFFF" sketch:type="MSShapeGroup"></path>
                </g>
                </svg>
            </div>
            <div class="dz-error-mark">
                <svg width="54px" height="54px" viewBox="0 0 54 54" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:sketch="http://www.bohemiancoding.com/sketch/ns">
                    <title>Error</title>
                    <defs></defs>
                        <g id="Page-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd" sketch:type="MSPage">
                            <g id="Check-+-Oval-2" sketch:type="MSLayerGroup" stroke="#747474" stroke-opacity="0.198794158" fill="#FFFFFF" fill-opacity="0.816519475">
                            <path d="M32.6568542,29 L38.3106978,23.3461564 C39.8771021,21.7797521 39.8758057,19.2483887 38.3137085,17.6862915 C36.7547899,16.1273729 34.2176035,16.1255422 32.6538436,17.6893022 L27,23.3431458 L21.3461564,17.6893022 C19.7823965,16.1255422 17.2452101,16.1273729 15.6862915,17.6862915 C14.1241943,19.2483887 14.1228979,21.7797521 15.6893022,23.3461564 L21.3431458,29 L15.6893022,34.6538436 C14.1228979,36.2202479 14.1241943,38.7516113 15.6862915,40.3137085 C17.2452101,41.8726271 19.7823965,41.8744578 21.3461564,40.3106978 L27,34.6568542 L32.6538436,40.3106978 C34.2176035,41.8744578 36.7547899,41.8726271 38.3137085,40.3137085 C39.8758057,38.7516113 39.8771021,36.2202479 38.3106978,34.6538436 L32.6568542,29 Z M27,53 C41.3594035,53 53,41.3594035 53,27 C53,12.6405965 41.3594035,1 27,1 C12.6405965,1 1,12.6405965 1,27 C1,41.3594035 12.6405965,53 27,53 Z" id="Oval-2" sketch:type="MSShapeGroup"></path>
                        </g>
                    </g>
                </svg>
            </div>
            <button type="button" data-dz-remove class="dz-remove btn btn-danger delete r-lg">
                <i class="ion-trash-b"></i>
            </button>
        </li>
        <div class="p-md">
            <ul class="list-inline">
                <li>
                    <button class="clickable btn btn-info" type="button">
                        <?php _e("Add image", osc_current_web_theme()) ?>
                    </button>
                </li>
                <li>
                    <span><?php _e("or drop it here", osc_current_web_theme()) ?></span>
                </li>
            </ul>
        </div>
        <div class="clearfix">
            <div class="thumbnail-label <?php echo ($edit && count($resources) > 0)? "":"hidden" ?>">
                <ul class="list-inline m-b-0">
                    <li><span class="label label-primary" style="width:<?php echo $dimThumbnail[0] ?>px"><?php _e("Thumbnail", osc_current_web_theme()) ?></span></li>
                    <li><span><?php echo (!$edit)? __("Drag picture to choose your thumbnail", osc_current_web_theme()):"" ?></span></li>
                </ul>
            </div>
            <ul class="previews list-inline m-l-0">
            </ul>
        </div>
    </div>
</div>
<?php endif; ?>