<?php if (osc_item_is_expired() && !osc_is_public_profile()) : ?>
    <p class="text-center m-b-0">
        <?php _e("The listing is expired. You can't contact the publisher.", osc_current_web_theme()); ?>
    </p>
<?php elseif (osc_is_web_user_logged_in() && osc_logged_user_id() == osc_item_user_id()) : ?>
    <p class="text-center m-b-0">
        <?php _e("It's your own listing, you can't contact the publisher.", osc_current_web_theme()); ?>
    </p>
<?php elseif (osc_is_web_user_logged_in() && osc_logged_user_id() == osc_user_id()) : ?>
    <p class="text-center m-b-0">
        <?php _e("You can't contact yourself.", osc_current_web_theme()); ?>
    </p>
<?php elseif (osc_reg_user_can_contact() && !osc_is_web_user_logged_in()) : ?>
    <p class="text-center m-b-md">
        <?php _e("You must log in or register a new account in order to contact the advertiser", osc_current_web_theme()); ?>
    </p>
    <a class="btn btn-primary btn-block" href="<?php echo osc_user_login_url(); ?>">
        <?php _e('Login', osc_current_web_theme()); ?>
    </a>
    <div class="m-y-md text-sideline">
        <span><?php _e("Or", osc_current_web_theme()) ?></span>
    </div>
    <a class="btn btn-primary btn-block" href="<?php echo osc_register_account_url(); ?>">
        <?php _e('Register for a free account', osc_current_web_theme()); ?>
    </a>
<?php else : ?>
    <?php if (osc_plugin_is_enabled("madhouse_messenger/index.php") && mdh_messenger_is_contacted()) : ?>
        <div class="wrapper-flash">
            <div class="alert alert-info">
                <p>
                    <?php printf(__("You already have contacted %s for this listing.", osc_current_web_theme()), osc_item_contact_name()) ?>
                </p>
                <a class="alert-link" href="<?php echo mdh_thread_url(); ?>"><?php _e('See thread', osc_current_web_theme()) ; ?></a>
            </div>
        </div>
    <?php endif; ?>
    <form class="js-validate" name="contact_form" method="post" action="<?php echo osc_base_url(true); ?>" enctype="multipart/form-data">
        <?php
        if (osc_is_ad_page() || osc_is_item_contact_page()) :
            osc_prepare_user_info(); // Remove ?
            mcf_input_hidden("page", "item");
            mcf_input_hidden("action", "contact_post");
            mcf_input_hidden("id", osc_item_id());
        else :
            mcf_input_hidden("page", "user");
            mcf_input_hidden("action", "contact_post");
            mcf_input_hidden("id", osc_user_id());
        endif;

        // If messenger isn't enabled these fields need to be always displayed
        if (osc_plugin_is_enabled("madhouse_messenger/index.php") == false || !osc_is_web_user_logged_in()) :
            // Name input.
            mcf_input_generic(
                "text",
                'yourName',
                (Session::newInstance()->_getForm('pp_yourName') != '') ? Session::newInstance()->_getForm('pp_yourName') : "",
                __("Your name", osc_current_web_theme()),
                "",
                "",
                array(
                    "data-rule-required" => "true",
                    "data-msg-required" => __("This field is required", osc_current_web_theme())
                )
            );

            // Email input.
            mcf_input_generic(
                "text",
                "yourEmail",
                (Session::newInstance()->_getForm('pp_yourEmail') != '') ? Session::newInstance()->_getForm('pp_yourEmail') : "",
                __("Your e-mail address", osc_current_web_theme()),
                "",
                "",
                array(
                    "data-rule-required" => "true",
                    "data-msg-required" => __("This field is required", osc_current_web_theme()),
                    "data-rule-email" => "true",
                    "data-msg-email" => __("The input is not a valid email address", osc_current_web_theme())
                )
            );

            // Phone input.
            mcf_input_generic(
                "text",
                "phoneNumber",
                "",
                __('Phone number', osc_current_web_theme()),
                "",
                ""
            );
        endif;

        if (osc_plugin_is_enabled("madhouse_messenger/index.php") && !mdh_messenger_is_contacted() && mdh_messenger_subject_enabled()) :
            // Subject input.
            mcf_input_generic(
                "text",
                "subject",
                (Session::newInstance()->_getForm('pp_subject') != '')?Session::newInstance()->_getForm('pp_subject') : "",
                __('Subject', osc_current_web_theme()),
                "",
                ""
            );
        endif;

        $message = "";
        if (osc_plugin_is_enabled("madhouse_messenger/index.php") ) {
            $message = mdh_messenger_message_template();
        }

        // Message input.
        mcf_input_generic(
            "textarea",
            "message",
            (Session::newInstance()->_getForm('pp_message') != '') ? Session::newInstance()->_getForm('pp_message') : $message,
            __("Message", osc_current_web_theme()),
            "",
            "",
            array(
                "data-rule-required" => "true",
                "data-msg-required" => __("This field is required", osc_current_web_theme())
            )
        );

        if (osc_item_attachment()) : ?>
            <?php
                // Attachment input.
                mcf_input_generic(
                    "file",
                    "attachment",
                    "",
                    __("Attachment",osc_current_web_theme()),
                    "",
                    ""
                );
            ?>
        <?php endif; ?>

        <?php
            osc_run_hook('item_contact_form', osc_item_id());

            if (!osc_is_web_user_logged_in()):
                mcf_show_recaptcha();
            endif;


            mcf_button(__('Send', osc_current_web_theme()), "btn-block btn-primary", "");
        ?>
    </form>
<?php endif; ?>
