<?php
/*
 * Block Name: Menu Search (form)
 * Block Slug: menu_search
 * Description: Blablabla.
 * Widget Hooks: menu_left, menu_right
 */ ?>

<form class="nocsrf navbar-left form-vertical" action="<?php echo osc_base_url(true); ?>" >
    <div class="dropdown navbar-form js-menu-search-container">
        <?php
        mcf_input_hidden("page", "search");
        ?>
        <div class="form-group">
            <div class="input-group">
                <input type="text" class="form-control hidden-sm js-menu-search-form <?php echo (osc_is_web_user_logged_in()) ? 'hidden-md' : "" ; ?>" name="sPattern" id="query"
                    class="input-text"
                    value=""
                    autocomplete="off"
                    placeholder="<?php echo osc_esc_html(mtk_field("$.layout", "s_search_placeholder", osc_current_user_locale())); ?>"
                />
                <span class="input-group-btn">
                    <button type="submit" class="btn btn-primary <?php echo (mtk_field("$.design", "i_navbar_inverse") == 0) ? "btn-outline" : ""; ?>">
                        <i class="ion-ios-search-strong hidden-xs"></i>
                        <span class="visible-xs-block"><?php _e("Search", osc_current_web_theme()) ?></span>
                    </button>
                </span>
            </div>
        </div>
        <div class="dropdown-menu hover-animated space-in width-lg m-t-sm dropdown-search">
            <div class="m-b-sm">
                <?php
                View::newInstance()->_exportVariableToView('header_form', true);
                osc_current_web_theme_path("parts/blocks/search/search-country-form.php");
                View::newInstance()->_erase('header_form');
                ?>
            </div>
            <div class="m-b-sm">
                <?php
                View::newInstance()->_exportVariableToView('header_form', true);
                osc_current_web_theme_path("parts/blocks/search/search-region-form.php");
                View::newInstance()->_erase('header_form');
                ?>
            </div>
            <div class="m-b-sm">
                <?php
                View::newInstance()->_exportVariableToView('header_form', true);
                osc_current_web_theme_path("parts/blocks/search/search-city-form.php");
                View::newInstance()->_erase('header_form');
                ?>
            </div>
            <div class="m-b-sm">
                <div class="form-group">
                    <label class="controler-label"><?php _e("Categories", osc_current_web_theme())  ?></label>
                    <div class="">
                        <?php mcf_categories_select(null, "") ?>
                    </div>
                </div>
            </div>
            <div class="">
                <button type="submit" class="btn btn-primary btn-outline btn-block">
                    <?php _e("Search", osc_current_web_theme()) ?>
                </button>
            </div>
        </div>
    </div>
</form>
