<?php
/*
 * Block Name: Item User Widget
 * Block Slug: item_user_simple
 * Description: Blablabla.
 * Widget Hooks: item_sidebar, item_contact, item_send_friend
 */ ?>

<div class="card card-flat card-user">
    <div class="card-block text-center">
        <?php if (function_exists("mdh_avatar_normal_url")) :?>
            <div class="row">
                <div class="col-xs-6 col-sm-12">
                    <div class="m-b">
                        <?php if (osc_item_user_id()) : ?>
                            <a class="d-b link-default" href="<?php echo osc_user_public_profile_url(osc_item_user_id()); ?>" >
                        <?php endif; ?>
                            <img class="img-avatar img-centered img-responsive" src="<?php echo mdh_avatar_preview_url(osc_user_id()) ;?>" />
                        <?php if (osc_item_user_id()) : ?>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-xs-6 col-sm-12">
        <?php endif; ?>
        <h3 class="card-title p-xs-y-md text-ellipsis user-name">
            <?php if (osc_item_user_id()) : ?>
                <a class="link-default" href="<?php echo osc_user_public_profile_url(osc_item_user_id()); ?>" >
                    <?php echo osc_item_contact_name(); ?>
                </a>
            <?php else : ?>
                <?php echo osc_item_contact_name(); ?>
            <?php endif; ?>
        </h3>
        <?php if (!osc_item_user_id()) : ?>
            <span class="text-muted font-bold">
                <?php _e("Unregistered user", osc_current_web_theme()) ?>
            </span>
        <?php endif ?>
        <?php mcf_voting_user_result(); ?>
        <ul class="list-unstyled text-muted text-sm m-b">
            <?php if (osc_item_show_email()) : ?>
                <li class="user-email m-b-sm">
                    <i class="ion-ios-email"></i>&nbsp;<?php echo osc_item_contact_email(); ?>
                </li>
            <?php endif; ?>
            <?php if (osc_user_phone() != "") : ?>
                <li class="user-phone m-b-sm">
                    <?php
                        $count = strlen(osc_user_phone()) - 4;
                        $phone = substr_replace(osc_user_phone(), str_repeat('X', $count), 3, $count);
                    ?>
                    <i class="ion-ios-telephone"></i>&nbsp;<?php echo (osc_is_web_user_logged_in() || !mtk_field('layout', 'i_item_phone_protected')) ? osc_user_phone() : $phone; ?>
                    <?php if (!osc_is_web_user_logged_in() || mtk_field('layout', 'i_item_phone_protected')): ?>
                        <a
                            href="#"
                            data-toggle="tooltip"
                            data-placement="left"
                            data-container="body"
                            title="<?php _e("Log in to see the phone number", osc_current_web_theme()) ?>"
                        >
                            <i class="ion-information-circled" ></i>
                        </a>
                    <?php endif ?>

                </li>
            <?php endif; ?>
            <?php if (!osc_is_web_user_logged_in() && function_exists('osc_telephone_number') && osc_telephone_number() != "") : ?>
                <li>
                    <i class="ion-ios-telephone d-ib"></i>
                    <span class="d-ib"><?php osc_telephone_number() ?></span>
                </li>
            <?php endif ?>
            <?php if (osc_user_website() != "") : ?>
                <li class="user-website m-b-sm">
                    <a href="<?php echo osc_user_website(); ?>" rel="nofollow" target="_blank">
                        <?php echo osc_user_website(); ?>
                    </a>
                </li>
            <?php endif; ?>
        </ul>
        <?php if (function_exists("mdh_avatar_normal_url")) :?>
                </div>
            </div>
        <?php endif; ?>
        <?php if (osc_item_user_id() && !Params::existParam('quick-view')) : ?>
            <div class="row m-b-lg">
                <div class="col-xs-6">
                    <div class="">
                        <span class="text-muted text-sm">
                            <?php _e("Listings", osc_current_web_theme()) ?>
                        </span>
                        <div>
                            <span class="font-secondary">
                                <?php echo osc_user_items_validated() ?>
                            </span>
                        </div>
                    </div>
                </div>
                <div class="col-xs-6">
                    <div class="">
                        <span class="text-muted text-sm">
                            <?php _e("Member since", osc_current_web_theme()) ?>
                        </span>
                        <div>
                            <span class="font-secondary">
                                <?php echo osc_format_date(osc_user_regdate()) ?>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
            <div class="row row-xs">
                <?php if (osc_item_user_id()) : ?>
                    <div class="col-xs-6 col-sm-12 col-md-6">
                        <a class="btn btn-primary btn-outline btn-block btn-sharp text-uppercase " href="<?php echo osc_user_public_profile_url(osc_item_user_id()); ?>">
                            <?php _e("Profile", osc_current_web_theme()); ?>
                        </a>
                    </div>
                <?php endif; ?>
                <div class="<?php echo (osc_item_user_id()) ? "col-xs-6 col-sm-12 col-md-6" : "col-xs-12" ?>">
                    <div class="dropdown item-report">
                        <a class="btn btn-default btn-block btn-sharp dropdown-toggle" data-toggle="dropdown" href="#">
                            <?php _e("Mark as...", osc_current_web_theme()); ?>
                        </a>
                        <ul class="dropdown-menu hover-animated">
                            <li>
                                <a id="item_spam" href="<?php echo osc_item_link_spam() ; ?>" rel="nofollow">
                                    <?php _e('Spam', osc_current_web_theme()) ; ?>
                                </a>
                            </li>
                            <li>
                                <a id="item_bad_category" href="<?php echo osc_item_link_bad_category() ; ?>" rel="nofollow">
                                    <?php _e('Misclassified', osc_current_web_theme()) ; ?>
                                </a>
                            </li>
                            <li>
                                <a id="item_repeated" href="<?php echo osc_item_link_repeated() ; ?>" rel="nofollow">
                                    <?php _e('Duplicated', osc_current_web_theme()) ; ?>
                                </a>
                            </li>
                            <li>
                                <a id="item_expired" href="<?php echo osc_item_link_expired() ; ?>" rel="nofollow">
                                    <?php _e('Expired', osc_current_web_theme()) ; ?>
                                </a>
                            </li>
                            <li>
                                <a id="item_offensive" href="<?php echo osc_item_link_offensive() ; ?>" rel="nofollow">
                                    <?php _e('Offensive', osc_current_web_theme()) ; ?>
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        <?php if (osc_is_web_user_logged_in() && osc_logged_user_id() == osc_item_user_id()) : ?>
            <div class="m-t-md">
                <a class="btn btn-default btn-block" href="<?php echo osc_item_edit_url(); ?>" rel="nofollow">
                    <?php _e("Edit item", osc_current_web_theme()); ?>
                </a>
            </div>
        <?php endif; ?>
    </div>
</div>
