<!DOCTYPE html>
<html class="height-full">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="initial-scale=1.0,maximum-scale=1.0">

        <!-- Title -->
        <title><?php echo meta_title() ; ?></title>
        <meta name="title" content="<?php echo osc_esc_html(meta_title()); ?>" />

        <?php if (meta_description() !== "") : ?>
            <!-- Description -->
            <meta name="description" content="<?php echo osc_esc_html(meta_description()); ?>" />
        <?php endif; ?>

        <?php if (meta_keywords() !== "") :?>
            <!-- Keywords -->
            <meta name="keywords" content="<?php echo osc_esc_html(meta_keywords()); ?>" />
        <?php endif; ?>

        <?php if (osc_get_canonical() !== "") : ?>
            <!-- Canonical -->
            <link rel="canonical" href="<?php echo osc_get_canonical(); ?>"/>
        <?php endif; ?>

        <?php if (mtk_favicon_url() !== "") : ?>
            <!-- Favicon -->
            <link rel="icon" type="image/x-icon" href="<?php echo mtk_favicon_url(); ?>" />
        <?php endif; ?>


        <?php osc_run_hook("header"); ?>
    </head>
    <body class="height-full bg-light  main
        <?php echo osc_apply_filter("body_class", ""); ?>
        <?php echo (mtk_field("$.layout", "i_nav_fixed") == 1)?"body-gap": "" ?>"
        <?php echo osc_apply_filter("body_attr", ""); ?>
    >

        <header>
            <div class="main-navbar navbar navbar-default <?php echo (mtk_field("$.layout", "i_nav_fixed") == 1)?"navbar-fixed-top": "navbar-static-top" ?>" role="banner">
                <div class="container">
                    <div class="navbar-header">
                        <a class="navbar-brand <?php echo (mtk_logo_url() != "")?"navbar-brand-img":"" ?>" href="<?php echo osc_base_url(); ?>">
                            <?php if (mtk_logo_url() != "") :
                            ?>
                            <img src="<?php echo mtk_logo_url() ?>">
                            <?php
else :
                                echo osc_page_title();
endif; ?>
                        </a>
                    </div>
                </div>
            </div>
        </header>
        <?php
            mcf_show_flash_message();
        ?>
        <div class="bg-gradient jumbotron text-center text-white">
            <h1 class="text-really-big"><?php printf(__('Maintenance &raquo; %s'), osc_page_title()); ?></h1>
        </div>
        <div class="container p-y-xl text-center">
            <div class="m-y-xl p-y-xl">
                <h2><?php printf(__('We are sorry for any inconvenience. %s is undergoing maintenance.'), osc_page_title()); ?></h2>
            </div>
        </div>

        <div class="text-center">
            <?php osc_current_web_theme_path("parts/blocks/social-networks.php"); ?>
        </div>
    </body>
</html>