<?php
    /**
     * Head location:   base.php
     * Header location: parts/header.php
     * Footer location: parts/footer.php
     */
?>

<?php osc_add_hook("content", function () {
    ?>
    <?php

    $action = 'item_add_post';
    $edit = false;
    if (Params::getParam('action') == 'item_edit') :
        $action = 'item_edit_post';
        $edit = true;
    endif;
    ?>


    <?php mcf_simple_title() ?>

    <div class="bg-light dk">
        <div class="container">
            <div class="hpadder-lg row">
                <div class="col-md-8 col-md-offset-2">
                    <div class="resp-wrapper">
                        <form
                            class="form-horizontal js-validate js-item-form"
                            name="item"
                            action="<?php echo osc_base_url(true);?>"
                            method="post"
                            enctype="multipart/form-data"
                            id="<?php echo ($edit) ? "item-id" : "item-post" ?>"
                            data-base-url="<?php echo osc_base_url(true); ?>"
                            data-display-location="<?php echo mtk_field("$.layout", "i_item_post_display_location")?>"
                        >
                            <?php
                            mcf_input_hidden("page", "item");
                            mcf_input_hidden("action", $action);
                            if ($edit) :
                                mcf_input_hidden("id", osc_item_id());
                                mcf_input_hidden("secret", osc_item_secret());
                            endif;
                            ?>
                            <h2 class="title-special"><?php _e('General Information', osc_current_web_theme()); ?></h2>
                            <div class="card">
                                <div class="card-block">
                                    <div class="form-group">
                                        <label class="col-sm-3 control-label" for="select_1">
                                            <?php _e('Category', osc_current_web_theme()); ?>
                                        </label>
                                        <div class="col-sm-9">

                                            <?php
                                            if (mtk_field("$.layout","i_item_post_display_category")):
                                                mcf_category_multiple_selects(null, null, __('Select a category', osc_current_web_theme()));
                                            else:
                                                mcf_category_select(null, null, __('Select a category', osc_current_web_theme()));
                                            endif;
                                            ?>
                                        </div>
                                    </div>
                                    <?php mcf_multilanguage_title_description() ?>

                                    <?php if (osc_price_enabled_at_items()) :  ?>
                                        <div class="form-group js-price">
                                            <label class="col-sm-3 control-label" for="price"><?php _e('Price', osc_current_web_theme()); ?></label>
                                            <div class="col-sm-3">
                                                <?php
                                                $data = array(
                                                    "id"               => "js-price-input",
                                                    "data-rule-number" =>"true",
                                                    "data-msg-number"  =>__("The price must be a valid number", osc_current_web_theme())
                                                );
                                                $value = (osc_item_price() !== "" && !is_null(osc_item_price()) )? osc_prepare_price(osc_item_price()) : "";
                                                $value = (osc_item_price() === 0 || osc_item_price() === 0.0)? 0 : $value ;
                                                mcf_input_text("price", $value, $data);
                                                ?>
                                            </div>
                                            <div class="col-sm-3">
                                                <?php

                                                $currencies = osc_get_currencies();
                                                $current = ($edit)? osc_item_currency() : osc_get_preference('currency');
                                                $current = ($current == "" && count($currencies) == 1) ? osc_get_preference('currency') : $current ;
                                                if (count($currencies) > 1) :
                                                    $value=array();
                                                    $value['current'] = $current;
                                                    $value['choices'] = $currencies;
                                                    $value['key_value'] = 'pk_c_code';
                                                    $value['key_name'] = 's_description';

                                                    mcf_input_select('currency', $value);
                                                elseif (count($currencies) == 1) :
                                                    mcf_input_hidden("currency", $current) ?>
                                                    <span class="l-h-input"><?php echo $currencies[0]['s_description']; ?></span>
                                                    <?php
                                                endif;
                                                ?>
                                            </div>
                                            <div class="col-sm-offset-3 col-sm-9">
                                                <span class="help-block">
                                                    <?php _e("Put 0 if your listing is free", osc_current_web_theme()) ?>
                                                </span>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div id="photos">
                                <?php if (mtk_field("$.layout", "i_item_post_ajax_photos")):
                                    if (osc_images_enabled_at_items()) : ?>
                                        <h2 class="title-special"><?php _e("Images", osc_current_web_theme()) ?></h2>
                                        <?php
                                            if (function_exists('przi_ajax_uploader')):
                                                przi_ajax_photos();
                                            else:
                                                ItemForm::ajax_photos();
                                            endif;
                                    endif;
                                else:
                                    osc_current_web_theme_path("parts/item/item-file-uploader.php");
                                endif; ?>
                            </div>

                            <h2 class="title-special"><?php _e('Listing Location', osc_current_web_theme()); ?></h2>
                            <div class="card">
                                <div class="card-block">
                                    <?php View::newInstance()->_exportVariableToView("location_style", !mtk_field("$.layout","i_item_post_display_location")); ?>
                                    <?php View::newInstance()->_exportVariableToView("col_label", "col-sm-3"); ?>
                                    <?php View::newInstance()->_exportVariableToView("col_input", "col-sm-9"); ?>
                                    <?php osc_current_web_theme_path('parts/location/country-form.php'); ?>

                                    <?php osc_current_web_theme_path('parts/location/region-form.php'); ?>

                                    <?php osc_current_web_theme_path('parts/location/city-form.php'); ?>

                                    <?php
                                    if (mtk_field("$.layout", "i_item_post_display_zip")) :
                                        $value = ($edit)? osc_item_zip() : osc_user_zip();
                                        $data = array();
                                        mcf_input_generic("text", 'zip', $value, __("Zip", osc_current_web_theme()), "col-sm-3", "col-sm-9", $data);
                                    endif;

                                    if (mtk_field("$.layout", "i_item_post_display_city_area")) :
                                        $value = ($edit)? osc_item_city_area() : osc_user_city_area();
                                        $data = array(
                                            "data-rule-minlength"=> 2,
                                            "data-msg-minlength"=>__("The city area name is too short", osc_current_web_theme()),
                                            "data-rule-maxlength"=> 50,
                                            "data-msg-maxlength"=>__("The city area name is too long (more than {0} characters)", osc_current_web_theme())
                                        );
                                        mcf_input_generic("text", 'cityArea', $value, __("City Area", osc_current_web_theme()), "col-sm-3", "col-sm-9", $data);
                                    endif;

                                    if (mtk_field("$.layout", "i_item_post_display_address")) :
                                        $value = ($edit)? osc_item_address() : osc_user_address();
                                        $data = array(
                                            "data-rule-minlength"=> 3,
                                            "data-msg-minlength"=>__("The address is too short", osc_current_web_theme()),
                                            "data-rule-maxlength"=> 100,
                                            "data-msg-maxlength"=>__("The address is too long (more than {0} characters)", osc_current_web_theme())
                                        );
                                        mcf_input_generic("text", 'address', $value, __("Address", osc_current_web_theme()), "col-sm-3", "col-sm-9", $data);
                                    endif; ?>
                                </div>
                            </div>

                            <!-- seller info -->
                            <?php if (!osc_is_web_user_logged_in()) : ?>
                                <div class="box seller_info">
                                    <h2 class="title-special"><?php _e("Seller's information", osc_current_web_theme()); ?></h2>
                                    <div class="card">
                                        <div class="card-block">
                                            <?php
                                            $data = array(
                                                "data-rule-required"=>"true",
                                                "data-msg-required"=>__("This field is required", osc_current_web_theme()),
                                                "data-rule-maxlength"=> 35,
                                                "data-msg-maxlength"=>__("Your name is too long (more than {0} characters)", osc_current_web_theme())
                                            );
                                            mcf_input_generic("text", 'contactName', osc_item_contact_name(), __("Name", osc_current_web_theme()), "col-sm-3", "col-sm-9", $data); ?>
                                            <?php
                                            $data = array(
                                                "data-rule-required"=>"true",
                                                "data-msg-required"=>__("This field is required", osc_current_web_theme()),
                                                "data-rule-email"=>"true",
                                                "data-msg-email"=>__("The input is not a valid email address", osc_current_web_theme())
                                            );
                                            mcf_input_generic("text", 'contactEmail', osc_item_contact_email(), __("E-mail", osc_current_web_theme()), "col-sm-3", "col-sm-9", $data);


                                            if (function_exists('osc_set_telephone_number')) {
                                                $value = Modelphone::newInstance()->t_check_value(osc_item_id());
                                                mcf_input_generic("text", 'telephone', $value['s_telephone'], __("Telephone", osc_current_web_theme()), "col-sm-3", "col-sm-9");
                                            }

                                                $item = osc_item();
                                            if (Session::newInstance()->_getForm('showEmail') != 0) {
                                                $item['b_show_email'] = Session::newInstance()->_getForm('showEmail');
                                            }
                                            ?>
                                            <div class="col-sm-9 col-sm-offset-3">
                                                <div class="checkbox">
                                                    <label>
                                                        <input type="checkbox" name="showEmail" value="1" <?php echo ($item["b_show_email"] == 1) ? 'checked="checked"' : ''; ?> /> <?php _e('Show e-mail on the listing page', osc_current_web_theme()) ?>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php
endif; ?>
                            <div class="js-plugin-hook-wrapper <?php echo ($edit)?"card card-block":"" ?>">
                                    <?php
                                    if ($edit) :
                                        ItemForm::plugin_edit_item();
                                    else :
                                        ItemForm::plugin_post_item();
                                    endif;
                                    ?>
                            </div>
                            <?php if (osc_plugin_is_enabled("nocaptcha_recaptcha/index.php") || osc_recaptcha_items_enabled()) : ?>
                                <div class="form-group">
                                    <div class="col-sm-offset-3 col-sm-4">
                                        <?php mcf_show_recaptcha(false); ?>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <?php
                            $text = ($edit)? __("Update", osc_current_web_theme()) : __("Publish", osc_current_web_theme());
                            mcf_button($text); ?>
                        </form>
                    </div>
                </div>
                <?php if (osc_locale_thousands_sep()!='' || osc_locale_dec_point() != '') : ?>
                    <script type="text/javascript">
                        $(document).ready(function(){
                            $("[name=price]").blur(function(event) {
                                var price = $("[name=price]").prop("value");
                                <?php if (osc_locale_thousands_sep()!='') { ?>
                                while(price.indexOf('<?php echo osc_esc_js(osc_locale_thousands_sep());  ?>')!=-1) {
                                    price = price.replace('<?php echo osc_esc_js(osc_locale_thousands_sep());  ?>', '');
                                }
                                <?php }; ?>
                                <?php if (osc_locale_dec_point()!='') { ?>
                                var tmp = price.split('<?php echo osc_esc_js(osc_locale_dec_point())?>');
                                if(tmp.length>2) {
                                    price = tmp[0]+'<?php echo osc_esc_js(osc_locale_dec_point())?>'+tmp[1];
                                }
                                <?php }; ?>
                                $("[name=price]").prop("value", price);
                            });

                        });
                    </script>
                <?php endif; ?>
            </div>
        </div>
    </div>

<?php }); ?>

<?php osc_current_web_theme_path("base-full.php"); ?>
