
var categoriesTree, depth;

function initCategoriesSelect(id)
{
    var $categoriesSelectTags = $('#js-categories-selects'),
        $form = $categoriesSelectTags.closest('form');

    if ($categoriesSelectTags.length === 0) {
        return;
    }

    $categoriesSelectTags.html("");

    currentCategory = findCategory(id);
    if (!jQuery.isEmptyObject(currentCategory)) {
        depth = categoryDepth(currentCategory);

        drawChildCategories(currentCategory);

        while (!jQuery.isEmptyObject(currentCategory)) {

            var categories = $.grep(categoriesTree, function (element, index) {
                return element.fk_i_parent_id == currentCategory.fk_i_parent_id;
            });

            drawCategoriesSelect(currentCategory, categories, true);

            var currentCategory = $.grep(categoriesTree, function (element, index) {
                return element.pk_i_id == currentCategory.fk_i_parent_id;
            });

            if (currentCategory.length == 0) {
                currentCategory = {};
            } else {
                currentCategory = currentCategory[0];
            }

            depth = depth - 1;
        }
    } else {
        var categories = $.grep(categoriesTree, function (element, index) {
            return element.fk_i_parent_id == null;
        });

        drawCategoriesSelect({}, categories, true);
    }

    $form.on("change", "#js-categories-selects > select", function (event) {
        if ("undefined" !== typeof $(this).attr("id") && $(this).attr("id").indexOf("category_select_") !== -1) {
            onChangeMultiCategory($(this).val(), $(this).attr("depth"), $form);
        }
    });
}

function onChangeMultiCategory(value, currentDepth, $form)
{
    depth = parseInt(currentDepth);
    var currentCategory = findCategory(value); // Get value

    // If value selected is null and not the first select, get the parent value
    if (depth > 0 && value == 0) {
        $form.find("[name='sCategory']").attr("value", $("#category_select_" + (depth - 1)).val());
    } else {
        $form.find("[name='sCategory']").attr("value", value);
    }

    $form.find("[name='sCategory']").trigger('input');

    // Remove next select
    for (var d = (depth + 1) ; d <= 5 ; d++) {

        $("#category_select_" + d).remove();
        //$("#category_select_" + d).trigger('removed');
    }

    drawChildCategories(currentCategory);

    // Re-get the custom fields.
    getCustomFields();
}

var drawCategoriesSelect = function (currentCategory, categories, init)
{
    var selectInput = '<select class="form-control m-b-sm js-submit-not" id="category_select_' + depth + '" depth="' + depth + '"></select>';

    if (init) {
        $('#js-categories-selects').prepend(selectInput);
    } else {
        $('#js-categories-selects').append(selectInput);
    }

    if (depth == 0 || $.isEmptyObject(currentCategory)) {
        var options = '<option value="" >' + _('Select category') + '</option>';
    } else {
        var options = '<option value="" >' + _('Select subcategory') + '</option>';
    }

    $.each(categories, function(index, category){
        options += '<option value="' + category.pk_i_id + '" ' + ((currentCategory.pk_i_id == category.pk_i_id) ?'selected="selected"':'') + '>' + category.s_name + '</option>';
    });

    $('#category_select_' + depth).html(options);
    //$('#category_select_' + depth).trigger("created");
}

var drawChildCategories = function (currentCategory)
{
    if (!jQuery.isEmptyObject(currentCategory)) {
        // Find child categories
        var categories = $.grep(categoriesTree, function (element, index) {
            return element.fk_i_parent_id == currentCategory.pk_i_id;
        });

        // If there is any, draw them
        if (categories.length > 0) {
            depth = depth + 1;
            drawCategoriesSelect({}, categories, false);
            depth = depth - 1;
        }
    }
}

var categoryDepth = function (cat)
{
    currentDepth = 0;
    while (cat.fk_i_parent_id != null) {
        currentDepth = currentDepth + 1;
        var cat = $.grep(categoriesTree, function (element, index) {
            return element.pk_i_id == cat.fk_i_parent_id;
        });
        cat = cat[0];
    }
    return currentDepth;
}

var findCategory = function (id)
{
    var $categoriesSelectTags = $('#js-categories-selects');
    if ($categoriesSelectTags.length === 0) {
        return;
    }

    // Global to this object.
    if (undefined === categoriesTree) {
        // Unserialize the category tree.
        var categoriesTreeString = $categoriesSelectTags.data("categoriesTree");
        if (categoriesTreeString) {
            // Global to this object.
            categoriesTree = $.parseJSON(categoriesTreeString.replace(/'/g,"\""));
        }
    }

    var currentCategory = $.grep(categoriesTree, function (element, index) {
        return element.pk_i_id == id || element.s_slug == id;
    });

    if (currentCategory.length > 0) {
        return currentCategory[0]
    }
    return {};
}

function getCustomFields() {
    var $form = $('.js-item-form'),
        baseUrl = $('body').data('baseUrl')
    ;

    $.ajax({
        'url': baseUrl + "?page=ajax&action=runhook&hook=search_form",
        'method': 'GET',
        'dataType': 'html',
        'data': {
            'sCategory' : $form.find('[name="sCategory"]').val()
        },
        'success': function (data, textStatus, jqXHR) {
            $('.plugin-hooks').html(data);
        },
        'error': function (jqXHR, textStatus, errorThrown) {
        },
        'complete': function (jqXHR, textStatus) {
        }
    });
}

$(document).ready(function() {

    /*
     * CATEGORY MULTI-SELECT.
     */
    var $categorySelect = $("[name='sCategory']");
    initCategoriesSelect($categorySelect.val());

    var $form           = $('.js-item-form'),
        baseUrl         = $('body').data('base-url'),
        textCountry     = _("Select a country..."),
        textRegion      = _("Select a region..."),
        textCity        = _("Select a city..."),
        textNoResults   = _("No results"),
        displayLocation = $form.data('display-location');

    if ($form.find('[name="sCategory"]').val()) {
        getCustomFields();
    }

    var $country = $('#country'),
    $countryId   = $('#countryId'),
    $region      = $('#region'),
    $regionId    = $('#regionId'),
    $city        = $('#city'),
    $cityId      = $('#cityId');

    if ($country.length) {
        $country.attr( "autocomplete", "off" );
    }
    $region.attr( "autocomplete", "off" );
    $city.attr( "autocomplete", "off" );


    $countryId.change(function(){
        $(this).closest('form').find('#regionId').val('');
        $(this).closest('form').find('#region').val('');
        $(this).closest('form').find('#cityId').val('');
        $(this).closest('form').find('#city').val('');
    });

    //
    // Location select

    $(document).on("change", 'select#sCountry', function(){
        var pk_c_code = $(this).val(),
            url           = baseUrl + "?page=ajax&action=regions&countryId=" + pk_c_code,
            result        = '',
            $sRegion      = $(this).closest('form').find("#sRegion"),
            $sCity        = $(this).closest('form').find("#sCity");

        $sRegion.attr('disabled', true);
        $sCity.attr('disabled', true);

        $.ajax({
            type: "POST",
            url: url,
            dataType: 'json',
            success: function(data) {
                var length = data.length;
                result += '<option selected value="">' + textRegion + '</option>';

                if (length > 0) {
                    for (key in data) {
                        result += '<option value="' + data[key].pk_i_id + '">' + data[key].s_name + '</option>';
                    }
                    $sRegion.html(result);
                    $sRegion.attr('disabled', false);
                }

                $sCity.html('<option selected value="">' + textCity + '</option>');
            }
         });
    });

    $(document).on("change", 'select#sRegion', function(){
        var pk_c_code = $(this).val();
        var url = baseUrl + "?page=ajax&action=cities&regionId=" + pk_c_code;

        var result = '',
            $sCity = $(this).closest('form').find("#sCity");

        $sCity.attr('disabled', true);

        $.ajax({
            type: "POST",
            url: url,
            dataType: 'json',
            success: function(data){
                var length = data.length;
                result += '<option selected value="">' + textCity + '</option>';

                if (length > 0) {
                    for (key in data) {
                        result += '<option value="' + data[key].pk_i_id + '">' + data[key].s_name + '</option>';
                    }

                    $sCity.html(result);
                    $sCity.attr('disabled', false);
                }

            }
         });
    });

    $(document).on('keyup.autocomplete', '#sCountry', function (event){
        if (event.which == 13) {
            return
        }

        var $form      = $(this).closest('form'),
            $city      = $form.find('#sCity'),
            $region    = $form.find('#sRegion'),
            $country   = $form.find('#sCountry');

        $country.attr("name", "sCountry");
        $form.find('input[name="sCountry"][type="hidden"]').remove();

        $(this).autocomplete({
            source: baseUrl + "?page=ajax&action=location_countries",
            minLength: 0,
            search  : function(){
                $(this).parent().addClass("loader");
            },
            response    : function(){
                $countryId.val("");
                $(this).parent().removeClass("loader");
            },
            select: function( event, ui ) {
                $country.before('<input type="hidden" name="sCountry" value=' + ui.item.id + '>');
                $country.attr("name", "");
                $region.val('');
                $('input[name="sRegion"][type="hidden"]').remove();
                $city.val('');
                $('input[name="sCity"][type="hidden"]').remove();
            }
        });
    });

    $(document).on('keyup.autocomplete', '#sRegion', function(event){
        if (event.which == 13) {
            return
        }

        var $form      = $(this).closest('form'),
            val        = $form.find('input[name="sCountry"]').val(),
            $city      = $form.find('#sCity'),
            $region    = $form.find('#sRegion'),
            $country   = $form.find('#sCountry');


        if (val != undefined) {
            var country = val;
        } else {
            var country = '';
        }

        $region.attr("name", "sRegion");
        $form.find('input[name="sRegion"][type="hidden"]').remove();

        $( this ).autocomplete({
            source: baseUrl + "?page=ajax&action=location_regions&country=" + country,
            minLength: 2,
            search  : function(){
                $(this).parent().addClass("loader");
            },
            response    : function(){
                $regionId.val('');
                $(this).parent().removeClass("loader");
            },
            select: function( event, ui ) {
                $region.before('<input type="hidden" name="sRegion" value=' + ui.item.id + '>');
                $region.attr("name", "");
                $city.val('');
                $('input[name="sCity"][type="hidden"]').remove();
            }
        });
    });

    $(document).on('keyup.autocomplete', '#sCity', function(){
        if (event.which == 13) {
            return
        }

        var $form      = $(this).closest('form'),
            val        = $form.find('input[name="sRegion"]').val(),
            $city      = $form.find('#sCity'),
            $region    = $form.find('#sRegion'),
            $country   = $form.find('#sCountry');

        if (val != undefined) {
            var region = val;
        } else {
            var region = '';
        }

        $city.attr("name", "sCity");
        $('input[name="sCity"][type="hidden"]').remove();

        $(this).autocomplete({
            source: function (request, response) {
                $.ajax({
                    type: 'GET',
                    url: baseUrl + "?page=ajax&action=location_cities&region=" + region + "&term="+encodeURIComponent(request.term),
                success: function( data ) {
                    response( $.map( JSON.parse(data), function( item ) {
                        return {
                            label: item.label + " (" + item.region + ")",
                            value: item.label,
                            id   : item.id
                        }
                    }));
                }
                })
            },
            minLength: 2,
            autoFocus: true,
            search: function() {
                $(this).parent().addClass("loader");
            },
            response: function() {
                $cityId.val('');
                $(this).parent().removeClass("loader");
            },
            select: function (event, ui) {
                $city.before('<input type="hidden" name="sCity" value=' + ui.item.id + '>');
                $city.attr("name", "");
            }
        });
    });

    /*
     * PRICE RANGE.
     * Clever jQuery UI price range for the search.
     */
    function generateSliders() {
        /* Slider */
        var $sliderElement = $(".js-price-range");
        if ($sliderElement.length) {
            var $sliderContainer = $sliderElement.closest(".ui-slider-box"),
                $priceMin = $sliderContainer.children(".js-price-min-input"),
                $priceMax = $sliderContainer.children(".js-price-max-input"),
                priceMin = 0,
                priceMax = $sliderElement.data("priceMax")
            ;

            // Update status callback (jQuery UI).
            var onUpdateState = function (event, ui) {
                var $this = $(this),
                    $sliderBox = $this.parents(".ui-slider-box"),
                    // If ui.values is undefined, we're most likely on the create event.
                    values = ("undefined" !== typeof ui.values) ? ui.values : $this.slider("option", "values")
                ;

                // Set the values to the min & max input fields (readonly & hidden).
                $priceMin.val(values[0]);
                $priceMax.val(values[1]);

                // Set the values to the min & max placeholders.
                $sliderBox.children('.js-price-min-label').html(values[0]);
                $sliderBox.children('.js-price-max-label').html(values[1]);

                // Disable the fields if min / max is set (not to submit the param).
                $priceMin.attr('disabled', priceMin === values[0]);
                $priceMax.attr('disabled', priceMax === values[1]);
            };

            // Attach to all form elements on page.
            $sliderElement.each(function (i, e) {
                $(this).slider({
                    range: true,
                    min: priceMin,
                    max: priceMax,
                    step: $sliderElement.data("priceStep"),
                    values: [
                        $priceMin.val() ? $priceMin.val() : priceMin,
                        $priceMax.val() ? $priceMax.val() : priceMax,
                    ],
                    slide: onUpdateState,
                    create: onUpdateState,
                    change: function (event, ui) {
                        $priceMin.trigger('input');
                        $priceMax.trigger('input');
                    }
                });
            });
        }
    }
    generateSliders();
});
