/**
 * Inits the i18n system (gettext Javascript implementation)
 * @type Gettext
 */
var gt = new Gettext({
    "domain": "theme"
});

/**
 * Shorthand function for i18n (PHP copy-cat of __).
 * @param  String msgid Key / English sentence to be translated.
 * @return String       Translated text.
 */
function _(msgid)
{
  return gt.gettext(msgid);
}

$(document).ready(function() {

    $(".navbar-toggle").on("click", function() {
        $(this).toggleClass("active");
    });

    /**
     * For performance reasons, tooltip is not activated by default.
     * ie. http://stackoverflow.com/questions/9446318/bootstrap-tooltips-not-working
     */
    $('[data-toggle="tooltip"]').tooltip({});

    /**
     * For modal to be centered vertically on window.
     */
    $(document).on('loaded.bs.modal', '.js-modal-center', function() {
        $(window).trigger('resize');
    });

    var $sliderMain = $(".js-slider-main"),
        sliderMainSpeed = ($sliderMain.data('speed') != "") ? $sliderMain.data('speed') : 5000;

    $(".js-slider-main").slick({
        slidesToShow: 1,
        slidesToScroll: 1,
        edgeFriction: 0,
        infinite: true,
        autoplay: true,
        arrows: false,
        fade: true,
        autoplaySpeed: sliderMainSpeed,
        pauseOnHover: false,
        lazyLoad: 'ondemand'
    });

    $(".js-slider-item").slick({
        slidesToShow: 4,
        slidesToScroll: 4,
        edgeFriction: 0.1,
        infinite: true,
        lazyLoad: 'ondemand',
        autoplay: false,
        autoplaySpeed: 4000,
        responsive: [{
            breakpoint: 1024,
            settings: {
                slidesToShow: 3,
                slidesToScroll: 3,
                infinite: true,
                dots: true
            }
        }, {
            breakpoint: 600,
            settings: {
                slidesToShow: 2,
                slidesToScroll: 2
            }
        }, {
            breakpoint: 480,
            settings: {
                slidesToShow: 1,
                arrows: true,
                slidesToScroll: 1
            }
        }]
    });

    $(".js-slider-item-small").slick({
        slidesToShow: 3,
        slidesToScroll: 3,
        edgeFriction: 0.1,
        infinite: true,
        responsive: [{
            breakpoint: 991,
            settings: {
                slidesToShow: 2,
                slidesToScroll: 2
            }
        }, {
            breakpoint: 480,
            settings: {
                slidesToShow: 1,
                arrows: true,
                slidesToScroll: 1
            }
        }]
    });

    $(".js-slider-item, .js-slider-item-small").each(function(i, v) {
        $(this).slick('slickSetOption', 'autoplay', $(this).data("autoplay"), false);
        $(this).slick('refresh');
    });

    $('.js-slider-search').slick({
        slidesToShow: 1,
        slidesToScroll: 1,
        arrows: true,
        edgeFriction: 0.1,
        infinite: true,
        autoplay: false,
        lazyLoad: 'ondemand'
    });

    $sliderPagination = $('.slider-for-pagination');

    $('.slider-for').slick({
        slidesToShow: 1,
        slidesToScroll: 1,
        arrows: true,
        asNavFor: '.js-slider-nav',
        edgeFriction: 0.1,
        infinite: false,
        autoplay: false,
        lazyLoad: 'ondemand'
    }).on('init reInit afterChange', function(event, slick, currentSlide, nextSlide) {
        //currentSlide is undefined on init -- set it to 0 in this case (currentSlide is 0 based)
        var i = (currentSlide ? currentSlide : 0) + 1;
        $sliderPagination.text(i + ' / ' + slick.slideCount);
    });

    $('.js-fancybox').fancybox();

    $('.js-slider-fancybox').on("click", function(e) {
        e.preventDefault();
        $.fancybox($(".slick-active .fancy-resource"));
    }); // on click

    // On before slide change
    $('.slider-for').on('afterChange', function(event, slick, currentSlide) {
        $slickSlides = $('.js-slider-nav .slick-slide');
        $slickSlides.removeClass('slick-current');
        $slickSlides.eq(currentSlide).addClass('slick-current');
    });

    $('.js-slider-nav').slick({
        slidesToShow: 6,
        slidesToScroll: 1,
        asNavFor: '.slider-for',
        arrows: true,
        focusOnSelect: true,
        infinite: false,
        responsive: [{
            breakpoint: 991,
            settings: {
                slidesToShow: 3,
                slidesToScroll: 1
            }
        }]
    });

    $('.js-slider-nav .slick-slide').eq(0).addClass('slick-current');

    $('.js-slider-categories').slick({
        dots: false,
        infinite: true,
        slidesToShow: 5,
        centerMode: true,
        variableWidth: true
    });

    $('.js-slider-informations').slick({
        dots: false,
        infinite: true,
        slidesToShow: 1,
        adaptiveHeight: true,
        autoplay: true,
        autoplaySpeed: 4000
    });


    // Defaults value for jquery validate
    $.validator.setDefaults({
        ignore: "",
        errorPlacement: function(error, element) {

            if (element.parent('.input-group').length) {
                error.appendTo(element.parent().parent());
            } else
            if (element[0].tagName === 'SELECT') {
                error.appendTo(element.parent());
            } else if (element[0].type === "radio") {
                error.appendTo(element.parent().parent());
            } else {
                error.appendTo(element.parent());
            }

            var $tab = element.parents(".tab-pane");
            if ($tab.length > 0 && !$tab.hasClass("active")) {
                var id = $tab.attr("id");
                $('a[href="#' + id + '"]').tab('show');
            }
        },
        errorClass: "help-block validate",
        errorElement: "span",
        invalidHandler: function(event, validator) {
            var errors = validator.numberOfInvalids();
            if (errors && validator.errorList[0].element.type == "hidden") {
                $(document).scrollTop($("#" + validator.errorList[0].element.id).prev().offset().top - 100);
            } else if (errors) {
                validator.errorList[0].element.focus();
            }
            $("form .tab-content").each(function(index, tabContent) {

                var $tabWitherrors = $(tabContent).find(".tab-pane:hidden:has(.has-error)");

                if ($tabWitherrors.length > 0) {
                    var $tab = $tabWitherrors;
                    var id = $tab.attr("id");
                    $('a[href="#' + id + '"]').tab('show');
                }
            });
        },
        submitHandler: function(form) {
            if ($(this.currentForm).valid()) {
                this.submitButton.setAttribute('disabled', true);
                form.submit();
            }
        },
        highlight: function(element, errorClass, validClass) {
            var $element;
            $element = $(element);
            $element.parents(".form-group").addClass("has-error");
        },
        unhighlight: function(element, errorClass, validClass) {
            var $element;
            if (element.type === 'radio') {
                $element = this.findByName(element.name);
            } else {
                $element = $(element);
            }
            $element.parents(".form-group").removeClass("has-error");
        }
    });

    $(document).on("change", 'form [data-toggle=buttons] input', function() {
        $(this).valid();
    });

    $('.formValidate, .js-validate').each(function() { // attach to all form elements on page
        $(this).validate({ // initialize plugin on each form
            // global options for plugin
        });
    });

    $(".js-register-form").validate();
    $(".js-login-form").validate();

    /* center modal */
    // function centerModals(){
    //   $('.modal').each(function(i){
    //     var $clone = $(this).clone().css('display', 'block').appendTo('body');
    //     var top = Math.round(($clone.height() - $clone.find('.modal-content').height()) / 2);
    //     top = top > 0 ? top : 0;
    //     $clone.remove();
    //     $(this).find('.modal-content').css("margin-top", top);
    //   });
    // }
    // $('.modal').on('show.bs.modal', centerModals);
    // $(window).on('resize', centerModals);

    $('#js-listing-user-filter').bind('change', function(e) {
        $(this).closest('form').trigger('submit')
    })

    $('#modalQuickView').on('shown.bs.modal', function(event) {

        var button = $(event.relatedTarget);
        var href = button.data('href');
        var modal = $(this);

        modal.find('.modal-content').load(href, function() {
            $sliderPagination = $('.slider-for-pagination');

            modal.find('.slider-for').slick({
                slidesToShow: 1,
                slidesToScroll: 1,
                arrows: true,
                edgeFriction: 0.1,
                infinite: false,
                autoplay: false,
                lazyLoad: 'ondemand'
            }).on('init reInit afterChange', function(event, slick, currentSlide, nextSlide) {
                //currentSlide is undefined on init -- set it to 0 in this case (currentSlide is 0 based)
                var i = (currentSlide ? currentSlide : 0) + 1;
                $sliderPagination.text(i + ' / ' + slick.slideCount);
            });
        });
    });

    $('#modalQuickView').on('hidden.bs.modal', function(event) {
        var modal = $(this);
        modal.find('.modal-content').html('<div class="spinner"><div class="double-bounce1"></div><div class="double-bounce2"></div></div>');
    });

    $("#sub_alert").on('submit', function(e) {
        e.preventDefault();
        var serializeData = $(this).serialize();

        $.ajax({
            type: "POST",
            url: $(this).data("url"),
            data: serializeData,
            success: function(data) {
                if (data == 1) {
                    alert(_('You have sucessfully subscribed to the alert'));
                } else if (data == -1) {
                    alert(_('Invalid email address'));
                } else {
                    alert(_('There was a problem with the alert'));
                };
            },
            error: function(XMLHttpRequest, textStatus, errorThrown) {
                alert(_('There was a problem with the alert'));
            }
        });
        return false;
    });

    if ($(".js-search-filters-clone").length) {
        if ($(window).width() <= 767) {
            $(".js-search-filters").detach().appendTo(".js-search-filters-clone");
        }

        /*
         * Don't resize because of Android which triggers the event randomly.
         * Tested: Android V4.4 (Samsung Note4)
         */
        // $(window).resize(function() {
        //     if ($(window).width() <= 767) {
        //         $(".js-search-filters").detach().appendTo(".js-search-filters-clone");
        //     } else {
        //         $(".js-search-filters").detach().appendTo(".js-search-filters-source");
        //     }
        // });
    }

    /**
     * SLIDEOUT Plugin
     * https://github.com/Mango/slideout
     */

    var slideout = new Slideout({
        'panel': document.getElementById('js-slideout-panel'),
        'menu': document.getElementById('js-slideout-menu'),
        'padding': 256,
        'tolerance': 70,
        'touch': false
    });

    function checkOpen(eve) {
        if ($(window).width() > 767 && slideout.isOpen()) {
            eve.preventDefault();
            slideout.close();
        }
    }

    function addClick() {
        document.querySelector('#js-slideout-panel').addEventListener('click', checkOpen);
    }

    function removeClick() {
        document.querySelector('#js-slideout-panel').removeEventListener('click', checkOpen);
    }

    slideout.on('beforeopen', function() {
        $.each($('#js-slideout-menu').find('.dropdown').not('.js-menu-search-container'), function(i, val) {
            $(val).addClass('open');
        });
    });

    slideout.on('close', function() {
        $('#js-slideout-menu').find('.dropdown').removeClass('open');
        $('.js-slideout-toggle-button').removeClass('active');
    });


    slideout.on('beforeopen', function() {
        $('header').find(".navbar-fixed-top").addClass('navbar-fixed-top-open');
        $('header').find(".header-widgets").addClass('navbar-fixed-top-open');
    });

    slideout.on('beforeclose', function() {
        $('header').find(".navbar-fixed-top").removeClass('navbar-fixed-top-open');
        $('header').find(".header-widgets").removeClass('navbar-fixed-top-open');
    });

    /*
     * Don't resize because of Android which triggers the event randomly.
     * Tested: Android V4.4 (Samsung Note4)
     */
    // $(window).resize(function() {
    //     if (slideout.isOpen()) {
    //         slideout.close();
    //     }
    // });

    // Toggle button
    if ($('.js-slideout-toggle-button').length) {
        document.querySelector('.js-slideout-toggle-button').addEventListener('click', function() {
            slideout.toggle();
        });
    }

    slideout.on('open', addClick);
    slideout.on('close', removeClick);

    $("#js-slideout-menu").html($("#js-main-nav").html())

    $(".js-menu-search-form").on("focus", function(e) {
        if (!$(this).parents('.dropdown').hasClass("open")) {
            $(this).parents('.dropdown').addClass('open');
        }
    });

    $(document).on('mouseup touchend', function(e) {
        var container = $(".js-menu-search-container");

        if (container.hasClass("open") && !container.is(e.target) // if the target of the click isn't the container...
            && container.has(e.target).length === 0) // ... nor a descendant of the container
        {
            container.removeClass('open');
        }
    });

    if ($("#modal-delete-item").length) {
        $('#modal-delete-item').on('show.bs.modal', function(event) {
            var link = $(event.relatedTarget)
            var href = $(link).data('href');

            $("#js-delete-link").attr("href", href);
        });
    }

    if ($(".mdh-availability").length) {
        $(".mdh-availability").datepicker({
            showOn: 'focus',
            dateFormat: "yy-mm-dd",
            nextText: "",
            prevText: ""
        });
    }

    $('.js-masonry').imagesLoaded(function() {
        $('.js-masonry').masonry({
            // options...
            itemSelector: '.grid-item'
        });
    });

    // browser window scroll (in pixels) after which the "back to top" link is shown
    var offset = 300,
        //browser window scroll (in pixels) after which the "back to top" link opacity is reduced
        offset_opacity = 1200,
        //duration of the top scrolling animation (in ms)
        scroll_top_duration = 700,
        //grab the "back to top" link
        $back_to_top = $('.back-top');

    //hide or show the "back to top" link
    $(window).scroll(function(){
        ( $(this).scrollTop() > offset ) ? $back_to_top.addClass('back-top-is-visible') : $back_to_top.removeClass('back-top-is-visible back-top-fade-out');
        if( $(this).scrollTop() > offset_opacity ) {
            $back_to_top.addClass('back-top-fade-out');
        }
    });

    //smooth scroll to top
    $back_to_top.on('click', function(event){
        event.preventDefault();
        $('body,html').animate({
            scrollTop: 0 ,
            }, scroll_top_duration
        );
    });
});
